import time
import json
import sys

sys.path.append('/srv/datalogger_ecom/')
from gps.gps_lib import GpsLib
from lib.usb_dev_node import USBDevnode


# Config
f = open('/srv/datalogger_ecom/config_ecom.json')
config:dict = json.load(f)

# Global variables
USB_GPS = config["GPS_SENSOR"]["PORT"]
MODEL_GPS = config["GPS_SENSOR"]["MODEL"]
MIN_VALUE_SPEED = config["GPS_SENSOR"]["MIN_VALUE_SPEED"]
SERVER_IP = config["SERVER"]["IP"]
SERVER_PORT = config["SERVER"]["PORT"]

if __name__ == "__main__":
	usb_gps = USBDevnode(USB_GPS)
	GPS = GpsLib(usbdevnode= usb_gps, model= MODEL_GPS, min_value_speed= MIN_VALUE_SPEED, log_id="GPS_USB")
	GPS.set_server(SERVER_IP, SERVER_PORT)
	print(GPS.client_socket)
	GPS.set_panic_command("systemctl restart mining-gps")
	GPS.log("GPS USB initialized")

	while True:
		# Breathe
		silence_period = time.time() - GPS.last_timestamp
		if int(silence_period) > 40:
			GPS.panic("Too much GPS silence")
		print("last_timestamp: %s" % str(silence_period))
		time.sleep(1)
