# Proyecto de Comunicación Serial y Servidor UDP

Este proyecto está compuesto por dos partes principales:
1. **Módulo de configuración (SerialLib):** Gestiona la comunicación serial con sensores (PM100, GPS, temperatura).
2. **Servidor UDP (Server):** Recibe datos desde clientes, procesa la información y la almacena en una base de datos SQLite.

---

## Índice
- [Propósito](#propósito)
- [Requisitos](#requisitos)
- [Estructura del Proyecto](#estructura-del-proyecto)
- [Módulo de Configuración (SerialLib)](#módulo-de-configuración-seriallib)
  - [Descripción General](#descripción-general)
  - [Flujo del Programa](#flujo-del-programa)
  - [Ejemplo de Configuración](#ejemplo-de-configuración)
- [Servidor UDP (Server)](#servidor-udp-server)
  - [Descripción General](#descripción-general-1)
  - [Flujo del Programa](#flujo-del-programa-1)
  - [Ejemplo de Interacción](#ejemplo-de-interacción)
- [Manejo de Errores](#manejo-de-errores)

---

## Propósito
Este proyecto proporciona una solución integrada para:
- Leer datos de sensores conectados a través de un puerto serial.
- Procesar y validar los datos según su tipo (PM100, GPS, temperatura).
- Enviar y recibir datos utilizando un servidor UDP.
- Almacenar datos procesados en una base de datos SQLite para análisis posterior.

---

## Requisitos
- **Python 3.8+**
- Bibliotecas:
  - `serial`
  - `socket`
  - `sqlite3`
  - `threading`
  - `json`
  - `time`
  - `datetime`
- Archivo de configuración en formato JSON (ver [Ejemplo de Configuración](#ejemplo-de-configuración)).

---

## Estructura del Proyecto
```plaintext
src/
├── serial_lib.py         # Módulo para gestionar la comunicación serial.
├── server.py             # Servidor UDP para procesar y almacenar datos.
├── config.json           # Archivo de configuración.
├── database.db           # Base de datos SQLite para almacenamiento de datos.
└── utils.py              # Funciones auxiliares para logging y manejo de errores.
```

---

## Módulo de Configuración (SerialLib)

### Descripción General
El módulo `SerialLib` establece la comunicación serial con sensores y procesa los datos recibidos.

### Funcionalidades Principales
1. **Conexión serial:** Establece una conexión con un puerto USB configurado.
2. **Lectura de datos:** Lee continuamente datos del puerto serial.
3. **Procesamiento de datos:** Clasifica y procesa los datos según el tipo de sensor.
4. **Emisión de datos:** Filtra y valida los datos antes de emitirlos para otros módulos.

### Flujo del Programa
```plaintext
1. Inicialización:
   - Configura los sensores y el puerto serial.
2. Conexión:
   - Establece una conexión serial en un hilo independiente.
3. Lectura:
   - Lee datos del puerto serial y los pasa al procesador.
4. Procesamiento:
   - Clasifica los datos por tipo (PM100, GPS, temperatura).
   - Valida y emite los datos procesados.
```

### Ejemplo de Configuración
Archivo `config.json`:
```json
{
  "GPS_SENSOR": {
    "MODEL": "GPS_USB"
  },
  "DUST_SENSOR": {
    "MIN_VALUE_PM100": 0,
    "EVOS": ["EVO1", "EVO2"]
  }
}
```

---

## Servidor UDP (Server)

### Descripción General
El servidor `Server` escucha mensajes enviados por sensores a través de un socket UDP, procesa los datos recibidos y los almacena en una base de datos SQLite.

### Funcionalidades Principales
1. **Recepción de mensajes:** Escucha mensajes UDP desde clientes.
2. **Procesamiento de datos:** Clasifica y valida los datos según el tipo de sensor.
3. **Almacenamiento:** Calcula promedios y guarda los datos en SQLite.

### Flujo del Programa
```plaintext
1. Inicialización:
   - Configura el socket UDP y las variables temporales.
2. Recepción de mensajes:
   - Escucha continuamente datos de los clientes.
3. Procesamiento:
   - Clasifica los mensajes por tipo (PM100, GPS, temperatura).
   - Almacena temporalmente los datos procesados.
4. Almacenamiento:
   - Una vez acumulados suficientes paquetes, calcula promedios y guarda los datos.
```

### Ejemplo de Interacción
Cliente UDP:
```python
import socket
import json

client_socket = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
server_address = ("127.0.0.1", 20001)

message = {
    "name_id": "GPS_MASTER",
    "data": {"speed": 45.6, "timestamp": 1692753912}
}

client_socket.sendto(json.dumps(message).encode('utf-8'), server_address)
client_socket.close()
```

---

## Manejo de Errores
### Errores Comunes
1. **Error de conexión serial:**
   ```plaintext
   Error: Device not found
   Causa: El dispositivo USB no está conectado o el nodo es incorrecto.
   Solución: Verifica el archivo de configuración y los permisos del dispositivo.
   ```

2. **Error en JSON:**
   ```plaintext
   Error: JSONDecodeError
   Causa: El cliente envió un mensaje malformado.
   Solución: Verifica que el mensaje sea un JSON válido.
   ```

3. **Base de datos bloqueada:**
   ```plaintext
   Error: Database locked
   Causa: Demasiadas conexiones simultáneas o transacciones lentas.
   Solución: Optimiza las transacciones o aumenta el tiempo de espera.
   ```

---

## Créditos
Mining.
