import time
import json
import sys

sys.path.append('/srv/datalogger_ecom/')
from serial_lib import SerialLib
from lib.usb_dev_node import USBDevnode

# Config
f = open('/srv/datalogger_ecom/config_ecom.json')
config:dict = json.load(f)

# Global variables
USB_SERIAL_DUST = config["DUST_SENSOR"]["PORT"]
SERVER_IP = config["SERVER"]["IP"]
SERVER_PORT = config["SERVER"]["PORT"]


if __name__ == "__main__":
    devnode = USBDevnode(USB_SERIAL_DUST)
    RX = SerialLib(devnode, config= config, log_id="SERIAL")
    RX.set_server(SERVER_IP, SERVER_PORT)
    RX.set_panic_command("systemctl restart mining-serial")
    RX.log("mining serial, initialized")

    counter = 0
    while True:
        # Breathe
        silence_period = time.time() - RX.last_dust_timestamp
        if int(silence_period) > 20:
            RX.panic("Too much RX silence")
        print("last_dust_timestamp: %s" % str(silence_period))
        time.sleep(1)
