import json
import serial
import socket
import sqlite3
import threading
import json
from time import sleep
from datetime import datetime
import sys

sys.path.append('/srv/datalogger_ecom/')
from lib.utils import Utils
from database.models import Database


class Server(Utils):
    def __init__(self, max_len_packet_data, seconds_microdata, ip, port, mode, log_id = "SERVER"):
        self.log_id = log_id
        self.mode = mode
        self.microdata = {}
        self.packet_data = []
        self.max_len_packet_data = max_len_packet_data
        self.seconds_microdata = seconds_microdata
        self.timer_microdata = serial.serialutil.Timeout(self.seconds_microdata)
        self.flag_pm = False
        self.flag_gps = False
        self.acum_pm100 = []
        self.acum_speed = []
        self.count = 0
        self.database = Database()

        self.local_ip = ip
        self.local_port = port
        self.bufferSize = 1024
        self.UDPServerSocket = socket.socket(family=socket.AF_INET, type=socket.SOCK_DGRAM)
        self.UDPServerSocket.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
        self.UDPServerSocket.bind((self.local_ip, self.local_port))
        threading.Thread(target=self.read_client_data).start()

    def read_client_data(self)-> None:
        """_summary_
        """
        self.log(f"Server init listening [%s port %s]" % (self.local_ip, self.local_port))
        while True:
            try:
                # Wait from msg clients
                bytesAddressPair = self.UDPServerSocket.recvfrom(self.bufferSize)
                message = bytesAddressPair[0].decode('utf-8')
                msg =  json.loads(message)
                #print(msg)
                name_id = msg['name_id']
                self.process_data(name_id, msg)

                # Wait for GPS and PM100 
                if self.timer_microdata.expired():
                    if self.flag_gps and self.flag_pm: 
                        self.packet_data.append(self.microdata)
                        self.log(f"dato numero {self.count} : {self.microdata}")
                        self.count = self.count + 1

                    # Restart variables and timer
                    self.microdata = {}
                    self.timer_microdata.restart(self.seconds_microdata)
                    self.flag_gps = False
                    self.flag_pm = False
                    #self.count = self.count + 1
                    
                # Wait until complete n packet data
                if self.count == self.max_len_packet_data:
                    if self.packet_data:
                        self.log("Packet data")
                        pm100_avg =int(sum(self.acum_pm100) / len(self.acum_pm100))
                        speed_avg =int(sum(self.acum_speed) / len(self.acum_speed))
                        if not self.mode: #No esta en modo test, por lo que debe guardar datos
                            self.database.insert_ecom_data(pm100_avg, speed_avg, self.packet_data)
                        else:
                            self.log("Cuidado equipo en modo test, recuerde pasar a modo normal despues de pruebas")
                        
                    # Restart Variables and timer
                    self.acum_pm100 = []
                    self.acum_speed = []
                    self.packet_data = []
                    self.count = 0
                sleep(0.01)

            except Exception as ex:
                self.traceback()

    def process_data(self, name_id: str, payload: dict)-> None:
        """_summary_

        Args:
            name_id (str): _description_
            payload (dict): _description_
        """
        if name_id == "SERIAL":
            self.flag_pm = True
            self.acum_pm100.append(payload["data"]["pm100"])
            self.microdata.update(payload["data"])

        elif name_id== "GPS_USB" or name_id=="GPS_MASTER":
            self.flag_gps = True
            self.acum_speed.append(payload["data"]["speed"])
            self.microdata.update(payload["data"])
            
        elif name_id == "TEMPERATURE":
            self.microdata.update(payload["data"])

        else:
            print(f"That's not a valid type: {name_id}")




# Config
f = open('/srv/datalogger_ecom/config_ecom.json')
config:dict = json.load(f)

if __name__ == "__main__":
	Server( max_len_packet_data= config["SERVER"]["MAX_LEN_PACKET_DATA"], 
            seconds_microdata= config["SERVER"]["SECONDS_MICRODATA"],
            ip=config["SERVER"]["IP"], 
            port=config["SERVER"]["PORT"],
            mode = config["TEST_MODE"]
            )
