# Proyecto de Monitoreo y Procesamiento de Datos Ambientales

## Descripción General
Este proyecto es un sistema completo para la captura, procesamiento y gestión de datos ambientales utilizando diversos dispositivos y sensores conectados. El sistema permite la recopilación de datos como calidad del aire (PM10, PM100), datos meteorológicos (velocidad del viento, temperatura, humedad), y datos GPS, que son almacenados y procesados en intervalos específicos.

---

## Estructura del Proyecto
```
project/
├── ambient/
│   ├── __main__.py
│   ├── ambient_lib.py
│   ├── ambient.service
│   ├── install.sh
│   ├── uninstall.sh
├── config/
│   ├── __main__.py
│   ├── config_autoupload.json
│   ├── install.sh
│   ├── mining-config-autoupload.service
│   ├── uninstall.sh
├── database/
│   ├── database.db
│   ├── database.py
├── lib/
│   ├── mqtt.py
│   ├── usb_dev_node.py
│   ├── utils.py
├── serial/
│   ├── __main__.py
│   ├── install.sh
│   ├── mining-serial.service
│   ├── serial_lib.py
│   ├── uninstall.sh
├── server/
│   ├── __main__.py
│   ├── install.sh
│   ├── mining-server.service
│   ├── server_lib.py
│   ├── uninstall.sh
├── config_gimp.json
├── uninstall.sh
└── install.sh
```

---

## Componentes Principales
### 1. **Ambient**
- Captura y procesamiento de datos meteorológicos de estaciones ambientales.
- **Archivos Clave:**
  - `ambient/__main__.py`: Control principal de ejecución.
  - `ambient/ambient_lib.py`: Funcionalidades específicas para datos meteorológicos.
  - `ambient.service`: Archivo de configuración del servicio Systemd.
  - `install.sh` y `uninstall.sh`: Scripts para instalar y desinstalar el servicio.

### 2. **Config**
- Gestión de configuración y auto-subida de datos.
- **Archivos Clave:**
  - `config/__main__.py`: Control de configuración.
  - `config_autoupload.json`: Archivo de configuración.
  - `mining-config-autoupload.service`: Archivo del servicio Systemd.
  - `install.sh` y `uninstall.sh`: Scripts para instalación y desinstalación.

### 3. **Database**
- Gestión de la base de datos SQLite para almacenar datos recopilados.
- **Archivos Clave:**
  - `database/database.py`: Funciones para crear, reiniciar y consultar la base de datos.
  - `database/database.db`: Archivo SQLite de la base de datos.

### 4. **Lib**
- Biblioteca compartida con utilidades comunes.
- **Archivos Clave:**
  - `lib/mqtt.py`: Manejo de conexiones MQTT.
  - `lib/usb_dev_node.py`: Gestión de dispositivos USB.
  - `lib/utils.py`: Funciones de utilidad compartidas por todos los módulos.

### 5. **Serial**
- Gestión de datos de sensores conectados por puertos seriales.
- **Archivos Clave:**
  - `serial/__main__.py`: Control principal de ejecución.
  - `serial/serial_lib.py`: Funciones para manejar dispositivos seriales.
  - `mining-serial.service`: Configuración del servicio Systemd.
  - `install.sh` y `uninstall.sh`: Scripts de instalación y desinstalación.

### 6. **Server**
- Servidor que recibe y procesa datos de múltiples fuentes.
- **Archivos Clave:**
  - `server/__main__.py`: Control principal del servidor.
  - `server/server_lib.py`: Funciones del servidor.
  - `mining-server.service`: Configuración del servicio Systemd.
  - `install.sh` y `uninstall.sh`: Scripts de instalación y desinstalación.

---

## Instalación del Proyecto
### Requisitos Previos
- **Python 3.6 o superior.**
- Instalar dependencias:
  ```bash
  pip install -r requirements.txt
  ```
- Configurar las variables de entorno necesarias (ejemplo para `AMBIENT_KEY`):
  ```bash
  export AMBIENT_KEY="<clave_ambient>"
  ```

### Pasos de Instalación
1. **Instalar Servicios:**
   - Para cada módulo (`ambient`, `serial`, `server`, etc.), ejecutar el script `install.sh` correspondiente:
     ```bash
     cd ambient/
     sudo bash install.sh
     ```
2. **Verificar el Estado del Servicio:**
   ```bash
   sudo systemctl status ambient
   sudo systemctl status mining-serial
   sudo systemctl status mining-server
   ```

3. **Configurar la Base de Datos:**
   - Crear tablas:
     ```bash
     python3 database/database.py --create_database True
     ```
   - Consultar datos:
     ```bash
     python3 database/database.py --get_data True --limit 10
     ```

---

## Uso del Sistema
### Ejecución Manual
Para ejecutar un módulo manualmente:
```bash
python3 <ruta_del_módulo>/__main__.py
```
Ejemplo:
```bash
python3 ambient/__main__.py
```

### Visualización de Datos
Consultar los datos almacenados en la base de datos:
```bash
python3 database/database.py --get_data True --limit 20
```

### Reinicio de Servicios
Si necesitas reiniciar algún servicio:
```bash
sudo systemctl restart ambient
sudo systemctl restart mining-serial
sudo systemctl restart mining-server
```

---

## Funcionalidades Principales
1. **Captura de Datos:**
   - Recopila datos de sensores conectados (AMBIENT, SERIAL, GPS).
2. **Almacenamiento de Datos:**
   - Almacena promedios en intervalos de tiempo específicos (0, 15, 30, 45 minutos).
3. **Gestión de la Base de Datos:**
   - Reinicio y consulta de la base de datos.
4. **Configuración de Servicios:**
   - Servicios Systemd para ejecución automática.

---

## Estructura de la Base de Datos
La tabla principal `gimp_data` incluye:
- Promedios de PM10, PM100, velocidad, meteorológicos.
- Marca de tiempo y fecha.
- Estado de subida a servidores externos.

---

## Licencia
Este proyecto está bajo el desarrollo de Mining+.
