# Documentación del Sistema Ambient

## Descripción del Proyecto
El sistema **Ambient** captura datos ambientales de estaciones meteorológicas conectadas. Los datos incluyen parámetros como temperatura, humedad, velocidad del viento, radiación solar, índice UV, y más. Esta información se emite a un servidor configurado mediante sockets UDP y se utiliza para análisis posteriores.

---

## Requisitos Previos

### Dependencias
El sistema requiere Python y librerías específicas:
- **Python 3.6 o superior**
- Librerías:
  - `ambient_api`
  - `cryptography`
  - `thread`
  - `pynmea`

### Instalación de Dependencias
Para instalar las dependencias, ejecuta:
```bash
pip install ambient_api
pip install cryptography
pip install thread
pip install pynmea
```

---

## Configuración e Instalación

### Instalación del Servicio
1. Navega al directorio del sistema **Ambient**:
   ```bash
   cd /srv/datalogger_gimp/ambient
   ```
2. Ejecuta el script de instalación:
   ```bash
   sudo bash install.sh
   ```
3. Verifica el estado del servicio:
   ```bash
   sudo systemctl status ambient
   ```

### Desinstalación del Servicio
Para eliminar el servicio y sus configuraciones:
1. Ejecuta el script de desinstalación:
   ```bash
   sudo bash uninstall.sh
   ```
2. Asegúrate de que el servicio ya no está activo:
   ```bash
   sudo systemctl status ambient
   ```

---

## Estructura del Proyecto
```
ambient/
├── __main__.py          # Archivo principal que inicia el sistema
├── ambient_lib.py       # Biblioteca principal para manejar dispositivos Ambient
├── ambient.service      # Archivo de configuración de Systemd para el servicio
├── install.sh           # Script de instalación
├── uninstall.sh         # Script de desinstalación
```

---

## Funcionalidades

### Recopilación de Datos
- **Datos Ambientales**: Captura información de estaciones meteorológicas conectadas.
  - Velocidad del viento
  - Dirección del viento
  - Temperatura
  - Humedad
  - Radiación solar
  - Índice UV
- **Emisión**: Los datos recopilados se envían al servidor configurado en tiempo real mediante sockets UDP.

### Servicio Systemd
El sistema está diseñado para ejecutarse como un servicio en segundo plano utilizando **Systemd**. Esto permite una configuración persistente y reinicio automático en caso de fallos.

---

## Uso

### Ejecutar Manualmente
Para ejecutar el sistema sin Systemd:
```bash
python3 __main__.py
```

### Verificar el Estado del Servicio
```bash
sudo systemctl status ambient
```

---

## Desarrollo
El archivo principal `__main__.py` utiliza la biblioteca `ambient_lib.py` para interactuar con dispositivos Ambient y manejar la lógica de recopilación y emisión de datos. El archivo de servicio `ambient.service` asegura que el sistema se ejecute de manera persistente y reinicie automáticamente en caso de fallos.

---

## Solución de Problemas
- **El servicio no inicia**:
  1. Verifica los permisos de los archivos del proyecto.
  2. Asegúrate de que las dependencias están instaladas correctamente.
  3. Revisa los logs del servicio:
     ```bash
     sudo journalctl -u ambient
     ```

- **No se reciben datos**:
  - Asegúrate de que el dispositivo Ambient está conectado y configurado correctamente.
  - Verifica que la clave `AMBIENT_KEY` está definida en las variables de entorno.

---

## Licencia
Este módulo está bajo el desarrollo de Mining+.
