#!/usr/bin/python
import requests
import time
import json
import sys
import traceback

sys.path.append('/srv/datalogger_gimp/')
from lib.utils import Utils
from lib import mqtt

class AutouploadGPS(Utils):
    def __init__(self, log_id = "AutouploadGPS", filepath = "/gps_live.json"):
        self.log_id = log_id
        self.machine_name = self.get_product_name()
        self.machine_id = self.get_product_id()
        self.topic = ""
        self.filepath = filepath
        self.previous_data = None
        self.update_topic()

    def update_topic(self):
        try:
            f = open('/srv/datalogger_gimp/config_gimp.json')
            config:dict = json.load(f)

            # MINING
            self.activated_mining = config["AUTOUPLOAD"]["MINING"]["ACTIVATED"] 
            self.topic = config["AUTOUPLOAD"]["MINING"]["LOCATION"]

        except:
            self.activated_mining = 0
            self.topic = ""

            self.traceback()

    def check_gps_data(self):
        try:
            print("Check data")
            f = open(self.filepath)
            data:dict = json.load(f)
            # Upload data MQTT Mining
            if self.activated_mining: self.upload_mqtt(data, self.topic)

        except Exception as exc:
            self.traceback()
        time.sleep(0.25)

    def upload_mqtt(self, data, topic):
        try:
            client = mqtt.connect()
            if client.is_connected():  
                jsondata= {
                    "measurement": {
                        "machineid": int(self.machine_id),
                        "latitude" : data["latitude"],
                        "longitude": data["longitude"],
                        "speed_kmh": int(data["speed"]),
                    },
                    "equipo": {
                        "name": self.machine_name
                    },
                    "time": data["timestamp"]*1000
                    }

                self.log(f"Try upload GPS to MQTT {topic}")
                mqtt.publish(client= client, topic= topic, dict_data= jsondata)
                client.loop_stop()
                client.disconnect()
            else:
                print("No se logró conectar a MQTT")
        except:
            self.traceback()

# Main loop
if __name__ == "__main__":
    print("AUTOUPLOAD GPS")
    upload = AutouploadGPS()
    try:
        upload.check_gps_data()
    except:
        e = sys.exc_info()
        print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
        traceback.print_tb(e[2])
        foo = "bar" # do nothing

