# Datalogger GIMP

Un sistema de configuración y gestión de datos para sensores y sistemas de minería. Este proyecto permite manejar configuraciones para sensores de polvo, GPS, y más. También actualiza y limpia configuraciones automáticamente según los parámetros proporcionados.

## Funcionalidades

- **Gestión de Configuración**:
  - Actualización automática de configuraciones para sensores EYE3 y Mining.
  - Limpieza de configuraciones antiguas en archivos específicos.
  
- **Soporte para Sensores**:
  - Sensores de polvo (PM100, PM10, PM25).
  - Sensores GPS.

- **Archivos de Configuración**:
  - `config_gimp.json`: Contiene configuraciones principales para los sensores.
  - `config_autoupload.json`: Define tablas y parámetros de carga de datos.

## Requisitos Previos

1. **Python**:
   - Requiere Python 3.6 o superior.
   
2. **Dependencias**:
   Asegúrate de tener instaladas las siguientes bibliotecas:
   ```bash
   pip install requests
   ```

3. **Estructura del Proyecto**:
   - El proyecto debe estar ubicado en `/srv/datalogger_gimp/`.
   - Archivos requeridos:
     - `/srv/datalogger_gimp/__main__.py`
     - `/srv/datalogger_gimp/config_gimp.json`
     - `/srv/datalogger_gimp/config_autoupload.json`

## Uso

### 1. Actualizar Configuración

Para actualizar las configuraciones de EYE3 y Mining, ejecuta:

```bash
python3 __main__.py --update_config
```

Esto realiza los siguientes pasos:
- Verifica si existen los archivos de configuración requeridos. Si no existen, los crea con valores predeterminados.
- Descarga y actualiza la configuración de EYE3 desde un servidor remoto.
- Actualiza la configuración de Mining localmente.

### 2. Limpiar Configuración

Para eliminar configuraciones de EYE3 y Mining, usa:

```bash
python3 __main__.py --clean_config
```

Esto elimina entradas específicas de los archivos `config_autoupload.json`.

### 3. Ver Ayuda

Para ver todas las opciones disponibles:

```bash
python3 __main__.py --help
```

### 4. Archivos Generados

- `config_gimp.json`:
  Configuración predeterminada generada automáticamente si no existe:
  ```json
  {
    "SERVER": {
      "IP": "127.0.0.1",
      "PORT": 20001,
      "MAX_LEN_PACKET_DATA": 60,
      "SECONDS_MICRODATA": 2
    },
    "DUST_SENSOR": {
      "PORT": "nano",
      "MIN_VALUE_PM100": 0,
      "MIN_VALUE_PM10": 0,
      "MIN_VALUE_PM25": 0,
      "MAX_VALUE_PM25": 500,
      "EVOS": []
    },
    "GPS_SENSOR": {
      "PORT": "gps",
      "MIN_VALUE_SPEED": 3,
      "MODEL": "GPS_MASTER",
      "URL_EYE3": ""
    }
  }
  ```

- `config_autoupload.json`:
  Configuración básica para la subida de datos:
  ```json
  {
    "tables": {}
  }
  ```

## Estructura del Proyecto

```plaintext
/srv/datalogger_gimp/
│
├── __main__.py               # Script principal para gestión de configuraciones
├── config_gimp.json          # Configuración principal (creado automáticamente)
├── config_autoupload.json    # Configuración para autoupload (creado automáticamente)
├── lib/
│   └── utils.py              # Módulos de utilidades
```

## Posibles Errores

- **"Argumento no válido"**:
  Asegúrate de pasar un argumento válido como `--update_config` o `--clean_config`.

- **"Config_autoupload.json not found"**:
  Ejecuta `--update_config` para generar este archivo automáticamente.

## Contribuciones

1. Realiza un fork del proyecto.
2. Crea una rama para tus cambios:
   ```bash
   git checkout -b feature/nueva_funcionalidad
   ```
3. Realiza tus cambios y súbelos:
   ```bash
   git add .
   git commit -m "Agrega nueva funcionalidad"
   git push origin feature/nueva_funcionalidad
   ```
4. Abre un Pull Request en GitHub.

## Licencia

Este proyecto está bajo la licencia MIT.
