# Documentación del Sistema de Base de Datos

## Descripción General
Este módulo se encarga de la gestión de la base de datos del sistema de monitoreo ambiental. Permite crear, reiniciar, y consultar datos de una base de datos SQLite. Además, incluye herramientas para procesar grandes volúmenes de datos ambientales recolectados por el sistema.

---

## Requisitos Previos

### Dependencias
Este módulo requiere las siguientes librerías estándar de Python:
- `sqlite3`: Para la gestión de la base de datos.
- `argparse`: Para el manejo de argumentos de línea de comandos.
- `tabulate`: Para la presentación de datos en formato tabular.
- `traceback`: Para el manejo de errores y trazas.

---

## Estructura de la Base de Datos

### Tablas Principales
La base de datos utiliza una tabla principal denominada `gimp_data`, que almacena los datos recolectados por el sistema.

#### Estructura de la Tabla `gimp_data`
| Columna              | Tipo        | Descripción                                  |
|----------------------|-------------|----------------------------------------------|
| `id`                | INTEGER     | Identificador único del registro.           |
| `pm100_avg`         | FLOAT       | Promedio de partículas PM100.               |
| `pm10_avg`          | FLOAT       | Promedio de partículas PM10.                |
| `speed_avg`         | FLOAT       | Promedio de velocidad.                      |
| `wind_speed_avg`    | FLOAT       | Promedio de velocidad del viento.           |
| `wind_direction_avg`| FLOAT       | Promedio de dirección del viento.           |
| `wind_gust_avg`     | FLOAT       | Promedio de ráfagas de viento.              |
| `temperature_avg`   | FLOAT       | Promedio de temperatura.                    |
| `humidity_avg`      | FLOAT       | Promedio de humedad.                        |
| `rain_avg`          | FLOAT       | Promedio de lluvia.                         |
| `uvindex_avg`       | FLOAT       | Promedio del índice UV.                     |
| `solarrad_avg`      | FLOAT       | Promedio de radiación solar.                |
| `packet_data`       | TEXT        | Datos en bruto del paquete recibido.        |
| `timestamp`         | INTEGER     | Marca de tiempo Unix.                       |
| `datetime`          | DATETIME    | Fecha y hora en formato legible.            |
| `uploaded_mining`   | INTEGER     | Indicador de subida al servidor de minería. |
| `uploaded_eye3`     | INTEGER     | Indicador de subida al servidor Eye3.       |

---

## Funcionalidades

### Verificar la Conexión a la Base de Datos
El módulo verifica si la base de datos puede abrirse correctamente y muestra la versión de SQLite instalada:
```bash
python3 database.py --create_database True
```

### Crear Tablas
Se pueden crear tablas en la base de datos si aún no existen:
```bash
python3 database.py --create_database True
```

### Consultar Datos
El módulo permite consultar los datos almacenados en la base de datos:
```bash
python3 database.py --get_data True --limit 10
```

### Reiniciar la Base de Datos
Si necesitas eliminar y recrear la base de datos, puedes utilizar esta opción (pendiente de implementación):
```bash
python3 database.py --reset_db True
```

---

## Argumentos Disponibles
El script admite los siguientes argumentos de línea de comandos:

| Argumento               | Descripción                                        | Tipo    | Valor Predeterminado |
|-------------------------|----------------------------------------------------|---------|-----------------------|
| `--create_database`     | Crea las tablas definidas en la base de datos.     | `bool`  | `False`              |
| `--reset_db`            | Reinicia y recrea la base de datos.               | `bool`  | `False`              |
| `--get_data`            | Obtiene datos almacenados en la base de datos.    | `bool`  | `False`              |
| `--get_custome_data`    | Obtiene columnas específicas de la base de datos. | `str`   | `""`                 |
| `--limit`               | Especifica el número de filas a consultar.        | `int`   | `10`                 |

---

## Uso

### Crear la Base de Datos
```bash
python3 database.py --create_database database_name
```

### Consultar los Últimos 10 Registros
```bash
python3 database.py --get_data database_name --limit 10
```

### Consultar Columnas Personalizadas
```bash
python3 database.py --get_custome_data "temperature_avg, humidity_avg" --limit 5
```

### Reiniciar la Base de Datos
```bash
python3 database.py --reset_db database_name
```

---

## Estructura del Proyecto
```
database/
├── database.db         # Archivo SQLite donde se almacenan los datos.
├── database.py         # Script principal para gestionar la base de datos.
```

---

## Notas
- Asegúrete de tener permisos de escritura en el directorio donde se encuentra la base de datos.
- Puedes modificar las estructuras de las tablas ajustando el diccionario `TABLES` en el script.

---

## Licencia
Este proyecto está bajo el desarrollo de Mining+. 
