#/usr/bin/python
import time
import json
import sys

sys.path.append('/srv/datalogger_gimp/')
from gps.gps_lib import GpsLib
from lib.usb_dev_node import USBDevnode


# Config
f = open('/srv/datalogger_gimp/config_gimp.json')
config:dict = json.load(f)

# Global variables
USB_GPS = config["GPS_SENSOR"]["PORT"]
SERVER_IP = config["SERVER"]["IP"]
SERVER_PORT = config["SERVER"]["PORT"]

if __name__ == "__main__":
	usb_gps = USBDevnode(USB_GPS)
	GPS = GpsLib(usb_gps, log_id="GPS_USB")
	GPS.set_server(SERVER_IP, SERVER_PORT)
	print(GPS.client_socket)
	GPS.set_panic_command("systemctl restart mining-gps")
	GPS.log("GPS USB initialized")

	while True:
		silence_period = time.time() - GPS.last_gps_timestamp
		if int(silence_period) > 900:
			GPS.panic("Too much GPS silence")
		print("last_gps_timestamp: %s" % str(silence_period))
		time.sleep(1)


