# Documentación del Proyecto Serial

## Descripción del Proyecto

El módulo **Serial** es responsable de leer y procesar datos provenientes de sensores conectados a través de puertos seriales. Este módulo recopila datos de sensores de polvo (PM10 y PM100), GPS y temperatura, los valida y los emite al sistema para su procesamiento y almacenamiento.

---

## Estructura del Proyecto

```
project/
└── serial/
    ├── __main__.py
    ├── install.sh
    ├── mining-serial.service
    ├── serial_lib.py
    └── uninstall.sh
```

---

## Dependencias

- **Python 3.6 o superior**
- Librerías de Python:
  - `serial`
  - `time`
  - `threading`
  - `sqlite3`
  - `json`

---

## Instalación del Servicio

1. Ejecuta el script de instalación para configurar el servicio del módulo **Serial**:
   ```bash
   sudo bash install.sh
   ```

2. Verifica el estado del servicio:
   ```bash
   sudo systemctl status mining-serial
   ```

---

## Desinstalación del Servicio

Para eliminar el servicio y limpiar su configuración:
```bash
sudo bash uninstall.sh
```

---

## Uso

1. Ejecutar el módulo manualmente:
   ```bash
   python3 __main__.py
   ```

2. Monitorear logs para depuración:
   ```bash
   journalctl -u mining-serial.service
   ```

---

## Funcionalidades Principales

1. **Conexión Serial**
   - Intenta establecer una conexión con el puerto serial del dispositivo especificado.
   - Permite la lectura continua de datos de sensores conectados.

2. **Procesamiento de Datos**
   - Identifica el tipo de datos recibidos: polvo (PM10, PM100), GPS o temperatura.
   - Filtra y valida los datos según los límites definidos en la configuración.

3. **Emisión de Datos**
   - Los datos validados se emiten al servidor configurado en formato JSON para su almacenamiento y análisis posterior.

4. **Reinicio Automático**
   - Si el servicio se detiene o encuentra errores, puede reiniciarse automáticamente.

---

## Configuración

El archivo de configuración contiene los límites para los datos de polvo y la configuración del GPS. Ejemplo de configuración:

```json
{
  "DUST_SENSOR": {
    "MIN_VALUE_PM100": 0,
    "MIN_VALUE_PM10": 0,
    "EVOS": true
  },
  "GPS_SENSOR": {
    "MODEL": "GPS_USB"
  }
}
```

---

## Scripts Clave

- **`__main__.py`**
  - Archivo de ejecución principal que inicia el módulo y los procesos asociados.

- **`serial_lib.py`**
  - Biblioteca principal que contiene las funciones para conectar, leer y procesar datos seriales.

- **`install.sh`**
  - Configura e instala el servicio para iniciar automáticamente el módulo en segundo plano.

- **`uninstall.sh`**
  - Elimina el servicio y limpia configuraciones relacionadas.

- **`mining-serial.service`**
  - Archivo de configuración para Systemd que define cómo se ejecuta el servicio.

---

## Licencia

Este módulo está bajo el desarrollo de Mining+.