# Documentación del Proyecto

## Descripción del Proyecto
Este proyecto es un sistema de captura y procesamiento de datos ambientales que utiliza dispositivos conectados para recopilar información como velocidad del viento, dirección del viento, temperatura, humedad, radiación solar, y más. Los datos recopilados se almacenan en una base de datos SQLite y se procesan para generar promedios en intervalos de tiempo específicos. Además, el sistema permite el reinicio y la gestión de la base de datos.

---

## Requisitos Previos
### Dependencias del Proyecto
- **Python 3.6 o superior**
- Librerías de Python:
  - `sqlite3`
  - `tabulate`
  - `argparse`
  - `serial`
  - `socket`
  - `json`
  - `traceback`
  - `datetime`
  - `time`
  - `threading`

### Instalación de Dependencias
Ejecuta el siguiente comando para instalar las dependencias requeridas:

```bash
pip install -r requirements.txt
```

### Archivos Clave
- **`__main__.py`**: Controla la ejecución principal del sistema.
- **`install.sh`**: Script para la instalación del servicio.
- **`uninstall.sh`**: Script para desinstalar el servicio.
- **`server_lib.py`**: Contiene las funcionalidades principales del servidor.
- **`database.py`**: Administra la base de datos SQLite.
- **`mining-server.service`**: Archivo de configuración del servicio Systemd.

---

## Configuración del Sistema
### Instalación del Servicio
1. Ejecuta el script de instalación:
   ```bash
   sudo bash install.sh
   ```
2. Verifica el estado del servicio:
   ```bash
   sudo systemctl status mining-server
   ```

### Desinstalación del Servicio
Para eliminar el servicio:
```bash
sudo bash uninstall.sh
```

### Configuración de la Base de Datos
Si deseas crear o reiniciar la base de datos, utiliza los siguientes comandos:

- **Crear Tablas:**
  ```bash
  python3 database.py --create_database True
  ```

- **Reiniciar la Base de Datos:**
  ```bash
  python3 database.py --reset_db True
  ```

- **Obtener Datos:**
  ```bash
  python3 database.py --get_data True --limit 20
  ```

---

## Funcionalidades
### Recopilación de Datos
El sistema recopila datos de los siguientes sensores:
- **AMBIENT:** Datos meteorológicos.
- **SERIAL:** Datos de sensores de polvo (PM10 y PM100).
- **GPS:** Datos de geolocalización (coordenadas y velocidad).

### Almacenamiento de Datos
Los datos se almacenan en la base de datos SQLite en la tabla `gimp_data`. Cada registro incluye:
- Promedios de PM10, PM100 y velocidad.
- Promedios meteorológicos como velocidad del viento, temperatura y radiación solar.
- Datos adicionales como marcas de tiempo y estado de subida a servidores externos.

### Emisión de Datos
El sistema emite los datos recopilados en formato JSON al servidor configurado a través de un socket UDP.

### Cálculo de Promedios
Se calculan promedios de los datos recopilados en intervalos de 0, 15, 30 y 45 minutos.

---

## Scripts Clave
### `install.sh`
Configura el servicio y crea la base de datos si no existe. También se asegura de que las dependencias estén instaladas.

### `uninstall.sh`
Elimina los servicios y limpia cualquier configuración relacionada con el proyecto.

### `database.py`
Permite interactuar con la base de datos mediante argumentos:
- Crear tablas.
- Reiniciar la base de datos.
- Obtener datos específicos.

---

## Uso
### Ejecutar Manualmente
Puedes ejecutar el sistema de forma manual usando:
```bash
python3 __main__.py
```

### Visualizar Datos en la Base de Datos
Para obtener los últimos registros almacenados:
```bash
python3 database.py --get_data True --limit 10
```

---

## Estructura del Proyecto
```
project/
├── ambient/
│   └── __main__.py
│   └── ambient_lib.py
│   └── ambient.service
│   └── install.sh
│   └── uninstall.sh
├── config/
│   └── __main__.py
│   └── config_autoupload.json
│   └── install.sh
│   └── mining-config-autoupload.service
│   └── uninstall.sh
├── database/
│   └── database.db
│   └── database.py
├── lib/
│   └── mqtt.py
│   └── usb_dev_node.py
│   └── utils.py
├── serial/
│   └── __main__.py
│   └── install.sh
│   └── mining-serial.service
│   └── serial_lib.py
│   └── uninstall.sh
├── server/
│   └── __main__.py__
│   └── install.sh
│   └── mining-server.service
│   └── server_lib.py
│   └── uninstall.sh
├── config_gimp.json
├── uninstall.sh
└── install.sh

```

---

## Licencia
Este proyecto está bajo el desarrollo de Mining+. 
