import time
import json
import sys

sys.path.append('/srv/datalogger_mmr/')
from flow_lib import FlowLib
from lib.usb_dev_node import USBDevnode

# Config
f = open('/srv/datalogger_mmr/config_mmr.json')
config:dict = json.load(f)

# Global variables
USB_SERIAL_FLOW = config["FLOW_SENSOR"]["PORT"]
MODBUS_ID = config["FLOW_SENSOR"]["MODBUS_ID"]
SERVER_IP = config["SERVER"]["IP"]
SERVER_PORT = config["SERVER"]["PORT"]
MODEL_SENSOR_LEVEL = config["TABLET"]["MODEL_SENSOR_LEVEL"]
SHOW_LEVEL = config["TABLET"]["SHOW_LEVEL"]
SHOW_VOLUME = config["TABLET"]["SHOW_VOLUME"]
MAX_CISTERN_LEVEL = config["TABLET"]["MAX_CISTERN_LEVEL"] # Max nivel de estanque del aljibe

if __name__ == "__main__":
    devnode = USBDevnode(USB_SERIAL_FLOW)
    FLOW = FlowLib(devnode, MODEL_SENSOR_LEVEL, SHOW_LEVEL, SHOW_VOLUME, MAX_CISTERN_LEVEL, modbus_id = MODBUS_ID, log_id="FLOW")
    FLOW.set_server(SERVER_IP, SERVER_PORT)
    FLOW.set_panic_command("systemctl restart mining-flow")
    FLOW.log("mining flow, initialized")

    counter = 0
    while True:
        # Breathe
        silence_period = time.time() - FLOW.last_flow_timestamp
        if int(silence_period) > 20:
            FLOW.panic("Too much FLOW silence")
        print("last_flow_timestamp: %s" % str(silence_period))
        time.sleep(1)
