import json
import subprocess
from serial import Serial
from time import sleep

CONFIG_SOURCE = "/srv/datalogger_mmr/config_mmr.json"

def update_config(config_source, sensor, port):
    try:
        #ESCRIBIR JSON
        with open(config_source, 'r') as f:
            config = json.load(f)
            config[sensor]["PORT"] = port
            with open(config_source,'w') as archivo:
                json.dump(config, archivo, indent=len(config))
                print(f"Puerto arduino {sensor} - port {port} actualizado")
    except:
        print("No se pudo sobreescribir el json")

def comando(orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                return res.decode()
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

def read_serial(port):
    lines = ""
    try:
         serial_module = Serial(port, 38400, timeout=1)
         for i in range(5):
            raw_line = serial_module.readline().decode("utf-8")
            print(raw_line)
            lines = lines + raw_line
            sleep(0.5)

    except Exception as ex:
         print(ex)
    
    return lines

ports = comando("usb")
lines = ports.split("\n")
count = 0
list_arduinos = []
for line in lines:
    if "Puerto Fisico" in line:
          print(line)
          print(lines[count+1])
          print(lines[count+2])
          if "Arduino" in lines[count+1]:
                number_port = int(line.split(" ")[-1][-2])
                name_port = lines[count+2].split(" ")[-1]
                list_arduinos.append((number_port, name_port))
    count+=1

if len(list_arduinos) == 1:
    update_config(config_source= CONFIG_SOURCE, sensor="VALVE_SENSOR", port = list_arduinos[0][0])
    comando("systemctl restart mining-serial")
    print("Servicio serial reiniciado")

elif len(list_arduinos) == 2:
    comando("systemctl stop mining-serial", 0)
    # Check serial read
    for arduino in list_arduinos:
        print(arduino)
        lines = read_serial(port = arduino[1])
        if "modo" in lines: # Es el arduino nano del serial
            update_config(config_source= CONFIG_SOURCE, sensor="VALVE_SENSOR", port = arduino[0])
            comando("systemctl restart mining-serial")
            print("Servicio serial reiniciado")
        
        else: # Es el flujometro
            update_config(config_source= CONFIG_SOURCE, sensor="FLOW_SENSOR", port = arduino[0])
            #comando("systemctl restart mining-flow")
            comando("sh /srv/datalogger_mmr/flow/install.sh")
            print("Servicio del flujometro reiniciado")
else:
    print("Hay demasiados arduinos, no es posible autodetectar los puertos. Se mantendra la configuracion por defecto")
