import time
import json
import sys

sys.path.append('/srv/datalogger_mmr/')
from serial_lib import SerialLib
from lib.usb_dev_node import USBDevnode

# Config
f = open('/srv/datalogger_mmr/config_mmr.json')
config:dict = json.load(f)

# Global variables
USB_SERIAL_VALVE = config["VALVE_SENSOR"]["PORT"]
CALIBRATION_LEVEL_CURVE = config["VALVE_SENSOR"]["LEVEL_CURVE"] # Lista con min and max voltage signal: [v_min, v_max]
MODEL_SENSOR_LEVEL = config["TABLET"]["MODEL_SENSOR_LEVEL"] # TUF OR SATEL
MAX_CISTERN_LEVEL = config["TABLET"]["MAX_CISTERN_LEVEL"] # Max nivel de estanque del aljibe
SERVER_IP = config["SERVER"]["IP"]
SERVER_PORT = config["SERVER"]["PORT"]

if __name__ == "__main__":
    devnode = USBDevnode(USB_SERIAL_VALVE)
    RX = SerialLib(devnode, level_curve= CALIBRATION_LEVEL_CURVE, model_sensor_level= MODEL_SENSOR_LEVEL, max_cistern_level=MAX_CISTERN_LEVEL, log_id="SERIAL")
    RX.set_server(SERVER_IP, SERVER_PORT)
    RX.set_panic_command("systemctl restart mining-serial")
    RX.log("mining serial, initialized")

    counter = 0
    while True:
        # Breathe
        silence_period = time.time() - RX.last_valve_timestamp
        if int(silence_period) > 20:
            RX.panic("Too much RX silence")
        print("last_valve_timestamp: %s" % str(silence_period))
        time.sleep(1)
