/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.graphic.FontConfiguration;

public enum FontParam {
    TIMING(12, 0),
    ACTIVITY(12, 0),
    ACTIVITY_DIAMOND(11, 0),
    ARROW(13, 0),
    CIRCLED_CHARACTER(17, 1, "black", "Monospaced"),
    OBJECT_ATTRIBUTE(10, 0),
    OBJECT(12, 0),
    OBJECT_STEREOTYPE(12, 2),
    CLASS_ATTRIBUTE(10, 0),
    CLASS(12, 0),
    CLASS_STEREOTYPE(12, 2),
    COMPONENT(14, 0),
    INTERFACE(14, 0),
    INTERFACE_STEREOTYPE(14, 2),
    COMPONENT_STEREOTYPE(14, 2),
    NOTE(13, 0),
    PACKAGE(14, 0),
    PACKAGE_STEREOTYPE(14, 2),
    ACTOR(14, 0),
    ARTIFACT(14, 0),
    CLOUD(14, 0),
    FOLDER(14, 0),
    FILE(14, 0),
    FRAME(14, 0),
    STORAGE(14, 0),
    BOUNDARY(14, 0),
    CONTROL(14, 0),
    ENTITY(14, 0),
    AGENT(14, 0),
    RECTANGLE(14, 0),
    ARCHIMATE(14, 0),
    CARD(14, 0),
    NODE(14, 0),
    DATABASE(14, 0),
    QUEUE(14, 0),
    STACK(14, 0),
    SEQUENCE_BOX(13, 1),
    SEQUENCE_DIVIDER(13, 1),
    SEQUENCE_REFERENCE(13, 0),
    SEQUENCE_DELAY(11, 0),
    SEQUENCE_GROUP(11, 1),
    SEQUENCE_GROUP_HEADER(13, 1),
    PARTICIPANT(14, 0),
    PARTICIPANT_STEREOTYPE(14, 2),
    SEQUENCE_TITLE(14, 1),
    STATE(14, 0),
    STATE_ATTRIBUTE(12, 0),
    LEGEND(14, 0),
    TITLE(18, 0),
    CAPTION(14, 0),
    SWIMLANE_TITLE(18, 0),
    FOOTER(10, 0, "#888888", "SansSerif"),
    HEADER(10, 0, "#888888", "SansSerif"),
    USECASE(14, 0),
    USECASE_STEREOTYPE(14, 2),
    ARTIFACT_STEREOTYPE(14, 2),
    CLOUD_STEREOTYPE(14, 2),
    STORAGE_STEREOTYPE(14, 2),
    BOUNDARY_STEREOTYPE(14, 2),
    CONTROL_STEREOTYPE(14, 2),
    ENTITY_STEREOTYPE(14, 2),
    AGENT_STEREOTYPE(14, 2),
    RECTANGLE_STEREOTYPE(14, 2),
    ARCHIMATE_STEREOTYPE(14, 2),
    CARD_STEREOTYPE(14, 2),
    NODE_STEREOTYPE(14, 2),
    FOLDER_STEREOTYPE(14, 2),
    FILE_STEREOTYPE(14, 2),
    FRAME_STEREOTYPE(14, 2),
    DATABASE_STEREOTYPE(14, 2),
    QUEUE_STEREOTYPE(14, 2),
    STACK_STEREOTYPE(14, 2),
    ACTOR_STEREOTYPE(14, 2),
    SEQUENCE_STEREOTYPE(14, 2),
    PARTITION(14, 0),
    DESIGNED_DOMAIN(12, 0),
    DESIGNED_DOMAIN_STEREOTYPE(12, 2),
    DOMAIN(12, 0),
    DOMAIN_STEREOTYPE(12, 2),
    MACHINE(12, 0),
    MACHINE_STEREOTYPE(12, 2),
    REQUIREMENT(12, 0),
    REQUIREMENT_STEREOTYPE(12, 2);

    private final int defaultSize;
    private final int fontStyle;
    private final String defaultColor;
    private final String defaultFamily;

    private FontParam(int defaultSize, int fontStyle, String defaultColor, String defaultFamily) {
        this.defaultSize = defaultSize;
        this.fontStyle = fontStyle;
        this.defaultColor = defaultColor;
        this.defaultFamily = defaultFamily;
    }

    private FontParam(int defaultSize, int fontStyle) {
        this(defaultSize, fontStyle, "black", "SansSerif");
    }

    public final int getDefaultSize(ISkinParam skinParam) {
        if (this == ARROW && skinParam.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return 11;
        }
        if (this == CLASS_ATTRIBUTE) {
            return 11;
        }
        return this.defaultSize;
    }

    public final int getDefaultFontStyle(ISkinParam skinParam, boolean inPackageTitle) {
        if (this == STATE) {
            return this.fontStyle;
        }
        if (inPackageTitle || this == PACKAGE) {
            return 1;
        }
        return this.fontStyle;
    }

    public final String getDefaultColor() {
        return this.defaultColor;
    }

    public String getDefaultFamily() {
        return this.defaultFamily;
    }

    public FontConfiguration getFontConfiguration(ISkinParam skinParam) {
        return new FontConfiguration(skinParam, this, null);
    }
}

