/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

public class CommandIf
extends SingleLineCommand2<ActivityDiagram> {
    public CommandIf() {
        super(CommandIf.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexOptional((IRegex)new RegexOr("FIRST", new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)"), new RegexLeaf("BAR", "(?:==+)[%s]*([\\p{L}0-9_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([\\p{L}0-9_.]+))?"))), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW", "([=-]+(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.]))?[=-]*\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("BRACKET", "(?:\\[([^\\]*]+[^\\]]*)\\])?"), new RegexLeaf("[%s]*"), new RegexOr(new RegexLeaf("IF1", "if[%s]*[%g]([^%g]*)[%g][%s]*(?:as[%s]+([\\p{L}0-9_.]+)[%s]+)?"), new RegexLeaf("IF2", "if[%s]+(.+?)[%s]*")), new RegexLeaf("(?:then)?$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram system, LineLocation location, RegexResult arg) {
        Direction direction;
        String ifLabel;
        String ifCode;
        IEntity entity1 = CommandLinkActivity.getEntity(system, arg, true);
        if (entity1 == null) {
            return CommandExecutionResult.error("No if possible at this point");
        }
        if (arg.get("IF2", 0) == null) {
            ifCode = arg.get("IF1", 1);
            ifLabel = arg.get("IF1", 0);
        } else {
            ifCode = null;
            ifLabel = arg.get("IF2", 0);
        }
        system.startIf(Code.of(ifCode));
        int lenght = 2;
        if (arg.get("ARROW", 0) != null) {
            String arrow = StringUtils.manageArrowForCuca(arg.get("ARROW", 0));
            lenght = arrow.length() - 1;
        }
        IEntity branch = system.getCurrentContext().getBranch();
        Link link = new Link(entity1, branch, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), Display.getWithNewlines(arg.get("BRACKET", 0)), lenght, null, ifLabel, system.getLabeldistance(), system.getLabelangle());
        if (arg.get("ARROW", 0) != null && ((direction = StringUtils.getArrowDirection(arg.get("ARROW", 0))) == Direction.LEFT || direction == Direction.UP)) {
            link = link.getInv();
        }
        system.addLink(link);
        return CommandExecutionResult.ok();
    }
}

