/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AnnotatedWorker;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionBreak;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionEnd;
import net.sourceforge.plantuml.activitydiagram3.InstructionFork;
import net.sourceforge.plantuml.activitydiagram3.InstructionGoto;
import net.sourceforge.plantuml.activitydiagram3.InstructionGroup;
import net.sourceforge.plantuml.activitydiagram3.InstructionIf;
import net.sourceforge.plantuml.activitydiagram3.InstructionLabel;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.InstructionRepeat;
import net.sourceforge.plantuml.activitydiagram3.InstructionSimple;
import net.sourceforge.plantuml.activitydiagram3.InstructionSplit;
import net.sourceforge.plantuml.activitydiagram3.InstructionSpot;
import net.sourceforge.plantuml.activitydiagram3.InstructionStart;
import net.sourceforge.plantuml.activitydiagram3.InstructionStop;
import net.sourceforge.plantuml.activitydiagram3.InstructionSwitch;
import net.sourceforge.plantuml.activitydiagram3.InstructionWhile;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.SwimlanesC;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockRecentred;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;
import net.sourceforge.plantuml.ugraphic.comp.TextBlockCompressedOnXorY;

public class ActivityDiagram3
extends UmlDiagram {
    private SwimlaneStrategy swimlaneStrategy;
    private final SwimlanesC swinlanes = new SwimlanesC(this.getSkinParam(), this.getPragma());
    private boolean hasUrl = false;

    private void manageSwimlaneStrategy() {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_FORBIDDEN;
        }
    }

    public CommandExecutionResult swimlane(String name, HtmlColor color, Display label) {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_ALLOWED;
        }
        if (this.swimlaneStrategy == SwimlaneStrategy.SWIMLANE_FORBIDDEN) {
            return CommandExecutionResult.error("This swimlane must be defined at the start of the diagram.");
        }
        this.swinlanes.swimlane(name, color, label);
        return CommandExecutionResult.ok();
    }

    private void setCurrent(Instruction ins) {
        this.swinlanes.setCurrent(ins);
    }

    private Instruction current() {
        return this.swinlanes.getCurrent();
    }

    private LinkRendering nextLinkRenderer() {
        return this.swinlanes.nextLinkRenderer();
    }

    public void addActivity(Display activity, BoxStyle style, Url url, Colors colors) {
        this.manageSwimlaneStrategy();
        InstructionSimple ins = new InstructionSimple(activity, this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane(), style, url, colors);
        this.current().add(ins);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.manageHasUrl(activity);
        if (url != null) {
            this.hasUrl = true;
        }
    }

    public void addSpot(String spot) {
        InstructionSpot ins = new InstructionSpot(spot, this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane());
        this.current().add(ins);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.manageSwimlaneStrategy();
    }

    public CommandExecutionResult addGoto(String name) {
        InstructionGoto ins = new InstructionGoto(this.swinlanes.getCurrentSwimlane(), name);
        this.current().add(ins);
        this.setNextLinkRendererInternal(LinkRendering.none());
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addLabel(String name) {
        InstructionLabel ins = new InstructionLabel(this.swinlanes.getCurrentSwimlane(), name);
        this.current().add(ins);
        this.setNextLinkRendererInternal(LinkRendering.none());
        return CommandExecutionResult.ok();
    }

    public void start() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionStart(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer()));
        this.setNextLinkRendererInternal(LinkRendering.none());
    }

    public void stop() {
        this.manageSwimlaneStrategy();
        InstructionStop ins = new InstructionStop(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer());
        if (this.manageSpecialStopEndAfterEndWhile(ins)) {
            return;
        }
        this.current().add(ins);
    }

    public void end() {
        this.manageSwimlaneStrategy();
        InstructionEnd ins = new InstructionEnd(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer());
        if (this.manageSpecialStopEndAfterEndWhile(ins)) {
            return;
        }
        this.current().add(ins);
    }

    private boolean manageSpecialStopEndAfterEndWhile(Instruction special) {
        if (!(this.current() instanceof InstructionList)) {
            return false;
        }
        InstructionList current = (InstructionList)this.current();
        Instruction last = current.getLast();
        if (!(last instanceof InstructionWhile)) {
            return false;
        }
        InstructionWhile instructionWhile = (InstructionWhile)last;
        if (instructionWhile.containsBreak()) {
            return false;
        }
        instructionWhile.setSpecial(special);
        return true;
    }

    public void breakInstruction() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionBreak(this.swinlanes.getCurrentSwimlane(), this.nextLinkRenderer()));
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("activity3");
    }

    @Override
    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.ACTIVITY;
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        TextBlock result = this.swinlanes;
        result = new TextBlockCompressedOnXorY(CompressionMode.ON_X, result);
        result = new TextBlockCompressedOnXorY(CompressionMode.ON_Y, result);
        result = new TextBlockRecentred(result);
        ISkinParam skinParam = this.getSkinParam();
        result = new AnnotatedWorker(this, skinParam, fileFormatOption.getDefaultStringBounder()).addAdd(result);
        Dimension2D dim = result.getMinMax(fileFormatOption.getDefaultStringBounder()).getDimension();
        double margin = 10.0;
        double dpiFactor = this.getDpiFactor(fileFormatOption, Dimension2DDouble.delta(dim, 20.0, 0.0));
        ImageBuilder imageBuilder = new ImageBuilder(this.getSkinParam(), dpiFactor, fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        imageBuilder.setUDrawable(result);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption, this.seed(), os);
    }

    private final double getDpiFactor(FileFormatOption fileFormatOption, Dimension2D dim) {
        Scale scale = this.getScale();
        double dpiFactor = scale == null ? this.getScaleCoef(fileFormatOption) : scale.getScale(dim.getWidth(), dim.getHeight());
        return dpiFactor;
    }

    public void fork() {
        InstructionFork instructionFork = new InstructionFork(this.current(), this.nextLinkRenderer(), this.getSkinParam());
        this.current().add(instructionFork);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionFork);
    }

    public CommandExecutionResult forkAgain() {
        if (this.current() instanceof InstructionFork) {
            InstructionFork currentFork = (InstructionFork)this.current();
            currentFork.manageOutRendering(this.nextLinkRenderer(), false);
            this.setNextLinkRendererInternal(LinkRendering.none());
            currentFork.forkAgain();
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public CommandExecutionResult endFork(ForkStyle forkStyle, String label) {
        if (this.current() instanceof InstructionFork) {
            InstructionFork currentFork = (InstructionFork)this.current();
            currentFork.setStyle(forkStyle, label);
            currentFork.manageOutRendering(this.nextLinkRenderer(), true);
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(currentFork.getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public void split() {
        InstructionSplit instructionSplit = new InstructionSplit(this.current(), this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane());
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.current().add(instructionSplit);
        this.setCurrent(instructionSplit);
    }

    public CommandExecutionResult splitAgain() {
        if (this.current() instanceof InstructionSplit) {
            ((InstructionSplit)this.current()).splitAgain(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public CommandExecutionResult endSplit() {
        if (this.current() instanceof InstructionSplit) {
            ((InstructionSplit)this.current()).endSplit(this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionSplit)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public void startSwitch(Display test, HtmlColor color) {
        this.manageSwimlaneStrategy();
        InstructionSwitch instructionSwitch = new InstructionSwitch(this.swinlanes.getCurrentSwimlane(), this.current(), test, this.nextLinkRenderer(), color, this.getSkinParam());
        this.current().add(instructionSwitch);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionSwitch);
    }

    public CommandExecutionResult switchCase(Display labelCase) {
        if (this.current() instanceof InstructionSwitch) {
            boolean ok = ((InstructionSwitch)this.current()).switchCase(labelCase, this.nextLinkRenderer());
            if (!ok) {
                return CommandExecutionResult.error("You cannot put an elseIf here");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find switch");
    }

    public CommandExecutionResult endSwitch() {
        if (this.current() instanceof InstructionSwitch) {
            ((InstructionSwitch)this.current()).endSwitch(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionSwitch)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find switch");
    }

    public void startIf(Display test, Display whenThen, HtmlColor color) {
        this.manageSwimlaneStrategy();
        InstructionIf instructionIf = new InstructionIf(this.swinlanes.getCurrentSwimlane(), this.current(), test, whenThen, this.nextLinkRenderer(), color, this.getSkinParam());
        this.current().add(instructionIf);
        this.setNextLinkRendererInternal(LinkRendering.none());
        this.setCurrent(instructionIf);
    }

    public CommandExecutionResult elseIf(Display inlabel, Display test, Display whenThen, HtmlColor color) {
        if (this.current() instanceof InstructionIf) {
            boolean ok = ((InstructionIf)this.current()).elseIf(inlabel, test, whenThen, this.nextLinkRenderer(), color);
            if (!ok) {
                return CommandExecutionResult.error("You cannot put an elseIf here");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult else2(Display whenElse) {
        if (this.current() instanceof InstructionIf) {
            boolean result = ((InstructionIf)this.current()).swithToElse2(whenElse, this.nextLinkRenderer());
            if (!result) {
                return CommandExecutionResult.error("Cannot find if");
            }
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult endif() {
        if (this.current() instanceof InstructionIf) {
            ((InstructionIf)this.current()).endif(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionIf)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public void startRepeat(HtmlColor color, Display label) {
        this.manageSwimlaneStrategy();
        InstructionRepeat instructionRepeat = new InstructionRepeat(this.swinlanes.getCurrentSwimlane(), this.current(), this.nextLinkRenderer(), color, label);
        this.current().add(instructionRepeat);
        this.setCurrent(instructionRepeat);
        this.setNextLinkRendererInternal(LinkRendering.none());
    }

    public CommandExecutionResult repeatWhile(Display label, Display yes, Display out, Display linkLabel, Rainbow linkColor) {
        this.manageSwimlaneStrategy();
        if (this.current() instanceof InstructionRepeat) {
            InstructionRepeat instructionRepeat = (InstructionRepeat)this.current();
            LinkRendering back = new LinkRendering(linkColor).withDisplay(linkLabel);
            instructionRepeat.setTest(label, yes, out, this.nextLinkRenderer(), back);
            this.setCurrent(instructionRepeat.getParent());
            this.setNextLinkRendererInternal(LinkRendering.none());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find repeat");
    }

    public CommandExecutionResult backwardWhile(Display label) {
        this.manageSwimlaneStrategy();
        if (this.current() instanceof InstructionRepeat) {
            InstructionRepeat instructionRepeat = (InstructionRepeat)this.current();
            instructionRepeat.setBackward(label);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find repeat");
    }

    public void doWhile(Display test, Display yes, HtmlColor color) {
        this.manageSwimlaneStrategy();
        InstructionWhile instructionWhile = new InstructionWhile(this.swinlanes.getCurrentSwimlane(), this.current(), test, this.nextLinkRenderer(), yes, color, this.getSkinParam());
        this.current().add(instructionWhile);
        this.setCurrent(instructionWhile);
    }

    public CommandExecutionResult endwhile(Display out) {
        if (this.current() instanceof InstructionWhile) {
            ((InstructionWhile)this.current()).endwhile(this.nextLinkRenderer(), out);
            this.setNextLinkRendererInternal(LinkRendering.none());
            this.setCurrent(((InstructionWhile)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find while");
    }

    public final CommandExecutionResult kill() {
        if (!this.current().kill()) {
            return CommandExecutionResult.error("kill cannot be used here");
        }
        return CommandExecutionResult.ok();
    }

    public void startGroup(Display name, HtmlColor backColor, HtmlColor titleColor, HtmlColor borderColor, USymbol type, double roundCorner) {
        this.manageSwimlaneStrategy();
        InstructionGroup instructionGroup = new InstructionGroup(this.current(), name, backColor, titleColor, this.swinlanes.getCurrentSwimlane(), borderColor, this.nextLinkRenderer(), type, roundCorner);
        this.current().add(instructionGroup);
        this.setCurrent(instructionGroup);
    }

    public CommandExecutionResult endGroup() {
        if (this.current() instanceof InstructionGroup) {
            this.setCurrent(((InstructionGroup)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find group");
    }

    private void setNextLinkRendererInternal(LinkRendering link) {
        if (link == null) {
            throw new IllegalArgumentException();
        }
        this.swinlanes.setNextLinkRenderer(link);
    }

    private void setNextLink(LinkRendering linkRenderer) {
        if (linkRenderer == null) {
            throw new IllegalArgumentException();
        }
        if (this.current() instanceof InstructionCollection) {
            Instruction last = ((InstructionCollection)this.current()).getLast();
            if (last instanceof InstructionWhile) {
                ((InstructionWhile)last).afterEndwhile(linkRenderer);
            } else if (last instanceof InstructionIf) {
                ((InstructionIf)last).afterEndwhile(linkRenderer);
            }
        }
        this.setNextLinkRendererInternal(linkRenderer);
    }

    public void setLabelNextArrow(Display label) {
        if (this.current() instanceof InstructionWhile && ((InstructionWhile)this.current()).getLast() == null) {
            ((InstructionWhile)this.current()).overwriteYes(label);
            return;
        }
        this.setNextLinkRendererInternal(this.nextLinkRenderer().withDisplay(label));
    }

    public void setColorNextArrow(Rainbow color) {
        if (color == null) {
            return;
        }
        LinkRendering link = new LinkRendering(color);
        this.setNextLink(link);
    }

    public CommandExecutionResult addNote(Display note, NotePosition position, NoteType type, Colors colors) {
        boolean ok = this.current().addNote(note, position, type, colors, this.swinlanes.getCurrentSwimlane());
        if (!ok) {
            return CommandExecutionResult.error("Cannot add note here");
        }
        this.manageHasUrl(note);
        return CommandExecutionResult.ok();
    }

    private void manageHasUrl(Display display) {
        if (display.hasUrl()) {
            this.hasUrl = true;
        }
    }

    @Override
    public boolean hasUrl() {
        return this.hasUrl;
    }

    static enum SwimlaneStrategy {
        SWIMLANE_FORBIDDEN,
        SWIMLANE_ALLOWED;

    }
}

