/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines3;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.Rainbow;

public class CommandRepeatWhile3Multilines
extends CommandMultilines3<ActivityDiagram3> {
    public CommandRepeatWhile3Multilines() {
        super(CommandRepeatWhile3Multilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public RegexConcat getPatternEnd2() {
        return new RegexConcat(new RegexLeaf("TEST1", "(.*)"), new RegexLeaf("\\)"), new RegexLeaf(";?$"));
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("repeat[%s]?while"), new RegexLeaf("[%s]*"), new RegexLeaf("\\("), new RegexLeaf("TEST1", "(.*)$"));
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram3 diagram, BlocLines lines) {
        lines = lines.trim(false);
        RegexResult line0 = this.getStartingPattern().matcher(StringUtils.trin(lines.getFirst499().getString()));
        RegexResult lineLast = this.getPatternEnd2().matcher(lines.getLast499().getString());
        String test = line0.get("TEST1", 0);
        Display testDisplay = Display.getWithNewlines(test);
        for (StringLocated s : lines.subExtract(1, 1)) {
            testDisplay = testDisplay.add(s.getString());
        }
        String trailTest = lineLast.get("TEST1", 0);
        if (!StringUtils.isEmpty(trailTest)) {
            testDisplay = testDisplay.add(trailTest);
        }
        Display yes = Display.NULL;
        Display out = Display.NULL;
        Rainbow linkColor = Rainbow.none();
        Display linkLabel = Display.NULL;
        List<Display> splitted = testDisplay.splitMultiline(MyPattern.cmpile("\\)[%s]*(is|equals?)[%s]*\\(", 2));
        if (splitted.size() == 2) {
            testDisplay = splitted.get(0);
            yes = splitted.get(1);
        }
        return diagram.repeatWhile(testDisplay, yes, out, linkLabel, linkColor);
    }
}

