/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileSwitchNude;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FtileSwitchWithDiamonds
extends FtileSwitchNude {
    protected final Ftile diamond1;
    protected final Ftile diamond2;
    protected final List<Branch> branches;

    public FtileSwitchWithDiamonds(List<Ftile> tiles, List<Branch> branches, Swimlane in, Ftile diamond1, Ftile diamond2, StringBounder stringBounder) {
        super(tiles, in);
        this.branches = branches;
        this.diamond1 = diamond1;
        this.diamond2 = diamond2;
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        ArrayList<Ftile> result = new ArrayList<Ftile>(super.getMyChildren());
        result.add(this.diamond1);
        result.add(this.diamond2);
        return Collections.unmodifiableCollection(result);
    }

    public int getYdelta1a(StringBounder stringBounder) {
        return 20;
    }

    public int getYdelta1b(StringBounder stringBounder) {
        return 10;
    }

    @Override
    protected FtileGeometry calculateDimensionInternalSlow(StringBounder stringBounder) {
        FtileGeometry dim1 = this.diamond1.calculateDimension(stringBounder);
        FtileGeometry dim2 = this.diamond2.calculateDimension(stringBounder);
        FtileGeometry dimNude = super.calculateDimensionInternalSlow(stringBounder);
        FtileGeometry all = dim1.appendBottom(dimNude).appendBottom(dim2);
        return all.addDim(0.0, this.getYdelta1a(stringBounder) + this.getYdelta1b(stringBounder));
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        ug.apply(this.getTranslateDiamond1(stringBounder)).draw(this.diamond1);
        super.drawU(ug.apply(this.getTranslateMain(stringBounder)));
        ug.apply(this.getTranslateDiamond2(stringBounder)).draw(this.diamond2);
    }

    protected UTranslate getTranslateMain(StringBounder stringBounder) {
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        return new UTranslate(0.0, dimDiamond1.getHeight() + (double)this.getYdelta1a(stringBounder));
    }

    protected UTranslate getTranslateDiamond1(StringBounder stringBounder) {
        double y1 = 0.0;
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond1 = this.diamond1.calculateDimension(stringBounder);
        double x1 = dimTotal.getLeft() - dimDiamond1.getLeft();
        return new UTranslate(x1, 0.0);
    }

    protected UTranslate getTranslateDiamond2(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        FtileGeometry dimDiamond2 = this.diamond2.calculateDimension(stringBounder);
        double y2 = dimTotal.getHeight() - dimDiamond2.getHeight();
        double x2 = dimTotal.getLeft() - dimDiamond2.getWidth() / 2.0;
        return new UTranslate(x2, y2);
    }

    protected UTranslate getTranslateOf(Ftile tile, StringBounder stringBounder) {
        return this.getTranslateNude(tile, stringBounder).compose(this.getTranslateMain(stringBounder));
    }

    protected TextBlock getLabelPositive(Branch branch) {
        FontConfiguration fcArrow = new FontConfiguration(this.skinParam(), FontParam.ARROW, null);
        return branch.getLabelPositive().create(fcArrow, HorizontalAlignment.LEFT, (ISkinSimple)this.skinParam(), CreoleMode.SIMPLE_LINE);
    }
}

