/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CommandMultilinesHeader
extends CommandMultilines<TitledDiagram> {
    public CommandMultilinesHeader() {
        super("(?i)^(?:(left|right|center)?[%s]*)header$");
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^end[%s]?header$";
    }

    @Override
    public CommandExecutionResult execute(TitledDiagram diagram, BlocLines lines) {
        lines = lines.trim(false);
        Matcher2 m = this.getStartingPattern().matcher(lines.getFirst499().getStringTrimmed());
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String align = m.group(1);
        Display strings = (lines = lines.subExtract(1, 1)).toDisplay();
        if (strings.size() > 0) {
            diagram.getHeader().put(strings, HorizontalAlignment.fromString(align, HorizontalAlignment.RIGHT));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Empty header");
    }
}

