/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArrow;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;

public class CommandLinkElement
extends SingleLineCommand2<DescriptionDiagram> {
    private static final String KEY1 = "dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+";
    private static final String KEY2 = ",dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+";
    public static final String LINE_STYLE = "(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*";
    private static final String LINE_STYLE_MUTILPLES = "(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)";
    public static final String STYLE_COLORS_MULTIPLES = "-\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*)*)\\]->";

    public CommandLinkElement() {
        super(CommandLinkElement.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkElement.getGroup("ENT1"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL1", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexLeaf("HEAD2", "(0\\)|<<|[<^*+#0)]|<\\||[%s]+o)?"), new RegexLeaf("BODY1", "([-=.~]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*(?:(?:;(?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)*))\\])?"), new RegexLeaf("DIRECTION", "(?:(left|right|up|down|le?|ri?|up?|do?)(?=[-=.~0()]))?"), new RegexLeaf("INSIDE", "(?:(0|\\(0\\)|\\(0|0\\))(?=[-=.~]))?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("BODY2", "([-=.~]*)"), new RegexLeaf("HEAD1", "(\\(0|>>|[>^*+#0(]|\\|>|o[%s]+)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL2", "(?:[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), CommandLinkElement.getGroup("ENT2"), new RegexLeaf("[%s]*"), CommandLinkElement.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LABEL_LINK", "(?::[%s]*(.+))?$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.LINE);
    }

    private LinkType getLinkType(RegexResult arg) {
        String head1 = CommandLinkElement.trimAndLowerCase(arg.get("HEAD1", 0));
        String head2 = CommandLinkElement.trimAndLowerCase(arg.get("HEAD2", 0));
        LinkDecor d1 = LinkDecor.NONE;
        LinkDecor d2 = LinkDecor.NONE;
        if (head1.equals("(0")) {
            d1 = LinkDecor.CIRCLE_CONNECT;
        } else if (head1.equals("#")) {
            d1 = LinkDecor.SQUARE;
        } else if (head1.equals("0")) {
            d1 = LinkDecor.CIRCLE;
        } else if (head1.equals("(")) {
            d1 = LinkDecor.PARENTHESIS;
        } else if (head1.equals(">")) {
            d1 = LinkDecor.ARROW;
        } else if (head1.equals("*")) {
            d1 = LinkDecor.COMPOSITION;
        } else if (head1.equals("o")) {
            d1 = LinkDecor.AGREGATION;
        } else if (head1.equals("+")) {
            d1 = LinkDecor.PLUS;
        } else if (head1.equals(">>")) {
            d1 = LinkDecor.ARROW_TRIANGLE;
        } else if (head1.equals("^")) {
            d1 = LinkDecor.EXTENDS;
        } else if (head1.equals("|>")) {
            d1 = LinkDecor.EXTENDS;
        }
        if (head2.equals("0)")) {
            d2 = LinkDecor.CIRCLE_CONNECT;
        } else if (head2.equals("#")) {
            d2 = LinkDecor.SQUARE;
        } else if (head2.equals("0")) {
            d2 = LinkDecor.CIRCLE;
        } else if (head2.equals(")")) {
            d2 = LinkDecor.PARENTHESIS;
        } else if (head2.equals("<")) {
            d2 = LinkDecor.ARROW;
        } else if (head2.equals("*")) {
            d2 = LinkDecor.COMPOSITION;
        } else if (head2.equals("o")) {
            d2 = LinkDecor.AGREGATION;
        } else if (head2.equals("+")) {
            d2 = LinkDecor.PLUS;
        } else if (head2.equals("<<")) {
            d2 = LinkDecor.ARROW_TRIANGLE;
        } else if (head2.equals("^")) {
            d2 = LinkDecor.EXTENDS;
        } else if (head2.equals("<|")) {
            d2 = LinkDecor.EXTENDS;
        }
        LinkType result = new LinkType(d1, d2);
        String queue = this.getQueue(arg);
        if (queue.contains(".")) {
            result = result.goDashed();
        } else if (queue.contains("~")) {
            result = result.goDotted();
        } else if (queue.contains("=")) {
            result = result.goBold();
        }
        String middle = arg.get("INSIDE", 0);
        if ("0".equals(middle)) {
            result = result.withMiddleCircle();
        } else if ("0)".equals(middle)) {
            result = result.withMiddleCircleCircled1();
        } else if ("(0".equals(middle)) {
            result = result.withMiddleCircleCircled2();
        } else if ("(0)".equals(middle)) {
            result = result.withMiddleCircleCircled();
        }
        return result;
    }

    private static String trimAndLowerCase(String s) {
        if (s == null) {
            return "";
        }
        return StringUtils.goLowerCase(StringUtils.trin(s));
    }

    private Direction getDirection(RegexResult arg) {
        String dir = arg.get("DIRECTION", 0);
        if (dir == null) {
            return StringUtils.getQueueDirection(this.getQueue(arg));
        }
        return StringUtils.getQueueDirection(dir);
    }

    private String getQueue(RegexResult arg) {
        return arg.get("BODY1", 0) + arg.get("BODY2", 0);
    }

    private static RegexLeaf getGroup(String name) {
        return new RegexLeaf(name, "([\\p{L}0-9_.]+|\\(\\)[%s]*[\\p{L}0-9_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:|(?!\\[\\*\\])\\[[^\\[\\]]+\\]|\\((?!\\*\\))[^)]+\\))");
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) {
        Code ent1 = Code.of(arg.get("ENT1", 0));
        Code ent2 = Code.of(arg.get("ENT2", 0));
        if (diagram.isGroup(ent1) && diagram.isGroup(ent2)) {
            return this.executePackageLink(diagram, arg);
        }
        ILeaf cl1 = diagram.isGroup(ent1) ? diagram.getGroup(Code.of(arg.get("ENT1", 0))) : this.getOrCreateLeaf(diagram, ent1);
        ILeaf cl2 = diagram.isGroup(ent2) ? diagram.getGroup(Code.of(arg.get("ENT2", 0))) : this.getOrCreateLeaf(diagram, ent2);
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        String queue = dir == Direction.LEFT || dir == Direction.RIGHT ? "-" : this.getQueue(arg);
        Labels labels = new Labels(arg);
        Link link = new Link(cl1, cl2, linkType, Display.getWithNewlines(labels.labelLink), queue.length(), labels.firstLabel, labels.secondLabel, diagram.getLabeldistance(), diagram.getLabelangle());
        link.setLinkArrow(labels.linkArrow);
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.setColors(CommandLinkElement.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet()));
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        if (arg.get("STEREOTYPE", 0) != null) {
            Stereotype stereotype = new Stereotype(arg.get("STEREOTYPE", 0));
            link.setColors(link.getColors().applyStereotype(stereotype, diagram.getSkinParam(), ColorParam.arrow));
        }
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    private ILeaf getOrCreateLeaf(DescriptionDiagram diagram, Code code2) {
        char codeChar;
        String code = code2.getFullName();
        if (code.startsWith("()")) {
            return diagram.getOrCreateLeaf(Code.of(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(code.substring(2)))), LeafType.DESCRIPTION, USymbol.INTERFACE);
        }
        char c = codeChar = code.length() > 2 ? code.charAt(0) : (char)'\u0000';
        if (codeChar == '(') {
            return diagram.getOrCreateLeaf(code2.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.USECASE, USymbol.USECASE);
        }
        if (codeChar == ':') {
            return diagram.getOrCreateLeaf(code2.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.DESCRIPTION, USymbol.ACTOR);
        }
        if (codeChar == '[') {
            USymbol sym = diagram.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1;
            return diagram.getOrCreateLeaf(code2.eventuallyRemoveStartingAndEndingDoubleQuote("\"([:"), LeafType.DESCRIPTION, sym);
        }
        return diagram.getOrCreateLeaf(code2, null, null);
    }

    private CommandExecutionResult executePackageLink(DescriptionDiagram diagram, RegexResult arg) {
        IGroup cl1 = diagram.getGroup(Code.of(arg.get("ENT1", 0)));
        IGroup cl2 = diagram.getGroup(Code.of(arg.get("ENT2", 0)));
        LinkType linkType = this.getLinkType(arg);
        Direction dir = this.getDirection(arg);
        String queue = dir == Direction.LEFT || dir == Direction.RIGHT ? "-" : this.getQueue(arg);
        Link link = new Link(cl1, cl2, linkType, Display.getWithNewlines(arg.get("LABEL_LINK", 0)), queue.length());
        if (dir == Direction.LEFT || dir == Direction.UP) {
            link = link.getInv();
        }
        link.applyStyle(arg.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    static class Labels {
        private String firstLabel;
        private String secondLabel;
        private String labelLink;
        private LinkArrow linkArrow = LinkArrow.NONE;

        Labels(RegexResult arg) {
            this.firstLabel = arg.get("LABEL1", 0);
            this.secondLabel = arg.get("LABEL2", 0);
            this.labelLink = arg.get("LABEL_LINK", 0);
            if (this.labelLink != null) {
                if (this.firstLabel == null && this.secondLabel == null) {
                    this.init();
                }
                this.labelLink = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(this.labelLink);
                if ("<".equals(this.labelLink)) {
                    this.linkArrow = LinkArrow.BACKWARD;
                    this.labelLink = null;
                } else if (">".equals(this.labelLink)) {
                    this.linkArrow = LinkArrow.DIRECT_NORMAL;
                    this.labelLink = null;
                } else if (this.labelLink != null && this.labelLink.startsWith("< ")) {
                    this.linkArrow = LinkArrow.BACKWARD;
                    this.labelLink = StringUtils.trin(this.labelLink.substring(2));
                } else if (this.labelLink != null && this.labelLink.startsWith("> ")) {
                    this.linkArrow = LinkArrow.DIRECT_NORMAL;
                    this.labelLink = StringUtils.trin(this.labelLink.substring(2));
                } else if (this.labelLink != null && this.labelLink.endsWith(" >")) {
                    this.linkArrow = LinkArrow.DIRECT_NORMAL;
                    this.labelLink = StringUtils.trin(this.labelLink.substring(0, this.labelLink.length() - 2));
                } else if (this.labelLink != null && this.labelLink.endsWith(" <")) {
                    this.linkArrow = LinkArrow.BACKWARD;
                    this.labelLink = StringUtils.trin(this.labelLink.substring(0, this.labelLink.length() - 2));
                }
            }
        }

        private void init() {
            Pattern2 p1 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)[%g]([^%g]+)[%g]$");
            Matcher2 m1 = p1.matcher(this.labelLink);
            if (m1.matches()) {
                this.firstLabel = m1.group(1);
                this.labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m1.group(2))));
                this.secondLabel = m1.group(3);
                return;
            }
            Pattern2 p2 = MyPattern.cmpile("^[%g]([^%g]+)[%g]([^%g]+)$");
            Matcher2 m2 = p2.matcher(this.labelLink);
            if (m2.matches()) {
                this.firstLabel = m2.group(1);
                this.labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m2.group(2))));
                this.secondLabel = null;
                return;
            }
            Pattern2 p3 = MyPattern.cmpile("^([^%g]+)[%g]([^%g]+)[%g]$");
            Matcher2 m3 = p3.matcher(this.labelLink);
            if (m3.matches()) {
                this.firstLabel = null;
                this.labelLink = StringUtils.trin(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(StringUtils.trin(m3.group(1))));
                this.secondLabel = m3.group(2);
            }
        }
    }
}

