/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.CoordinateChange;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolCloud
extends USymbol {
    private static final boolean NEW = true;
    private static final boolean DEBUG = false;

    USymbolCloud() {
    }

    @Override
    public SkinParameter getSkinParameter() {
        return SkinParameter.CLOUD;
    }

    private void drawCloud(UGraphic ug, double width, double height, boolean shadowing) {
        UPath shape = this.getSpecificFrontierForCloud(width, height);
        if (shadowing) {
            // empty if block
        }
        ug.apply(new UTranslate(0.0, 0.0)).draw(shape);
    }

    private UPath getSpecificFrontierForCloudNew(double width, double height) {
        Random rnd = new Random((long)width + 7919L * (long)height);
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        double bubbleSize = 11.0;
        if (Math.max(width, height) / bubbleSize > 16.0) {
            bubbleSize = Math.max(width, height) / 16.0;
        }
        double margin1 = 8.0;
        Point2D.Double pointA = new Point2D.Double(8.0, 8.0);
        Point2D.Double pointB = new Point2D.Double(width - 8.0, 8.0);
        Point2D.Double pointC = new Point2D.Double(width - 8.0, height - 8.0);
        Point2D.Double pointD = new Point2D.Double(8.0, height - 8.0);
        if (width > 100.0 && height > 100.0) {
            this.complex(rnd, points, bubbleSize, pointA, pointB, pointC, pointD);
        } else {
            this.simple(rnd, points, bubbleSize, pointA, pointB, pointC, pointD);
        }
        points.add((Point2D)points.get(0));
        UPath result = new UPath();
        result.moveTo((Point2D)points.get(0));
        for (int i = 0; i < points.size() - 1; ++i) {
            this.addCurve(rnd, result, (Point2D)points.get(i), (Point2D)points.get(i + 1));
        }
        return result;
    }

    private void complex(Random rnd, List<Point2D> points, double bubbleSize, Point2D.Double pointA, Point2D.Double pointB, Point2D.Double pointC, Point2D.Double pointD) {
        double margin2 = 7.0;
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvX(pointA, 7.0), USymbolCloud.mvX(pointB, -7.0));
        points.add(USymbolCloud.mvY(pointB, 7.0));
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvY(pointB, 7.0), USymbolCloud.mvY(pointC, -7.0));
        points.add(USymbolCloud.mvX(pointC, -7.0));
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvX(pointC, -7.0), USymbolCloud.mvX(pointD, 7.0));
        points.add(USymbolCloud.mvY(pointD, -7.0));
        this.specialLine(bubbleSize, rnd, points, USymbolCloud.mvY(pointD, -7.0), USymbolCloud.mvY(pointA, 7.0));
        points.add(USymbolCloud.mvX(pointA, 7.0));
    }

    private void simple(Random rnd, List<Point2D> points, double bubbleSize, Point2D.Double pointA, Point2D.Double pointB, Point2D.Double pointC, Point2D.Double pointD) {
        this.specialLine(bubbleSize, rnd, points, pointA, pointB);
        this.specialLine(bubbleSize, rnd, points, pointB, pointC);
        this.specialLine(bubbleSize, rnd, points, pointC, pointD);
        this.specialLine(bubbleSize, rnd, points, pointD, pointA);
    }

    private static Point2D mvX(Point2D pt, double dx) {
        return new Point2D.Double(pt.getX() + dx, pt.getY());
    }

    private static Point2D mvY(Point2D pt, double dy) {
        return new Point2D.Double(pt.getX(), pt.getY() + dy);
    }

    private void specialLine(double bubbleSize, Random rnd, List<Point2D> points, Point2D p1, Point2D p2) {
        CoordinateChange change = new CoordinateChange(p1, p2);
        double length = change.getLength();
        Point2D middle = change.getTrueCoordinate(length / 2.0, -USymbolCloud.rnd(rnd, 1.0, 1.0 + Math.min(12.0, bubbleSize * 0.8)));
        this.bubbleLine(rnd, points, p1, middle, bubbleSize);
        this.bubbleLine(rnd, points, middle, p2, bubbleSize);
    }

    private void bubbleLine(Random rnd, List<Point2D> points, Point2D p1, Point2D p2, double bubbleSize) {
        CoordinateChange change = new CoordinateChange(p1, p2);
        double length = change.getLength();
        int nb = (int)(length / bubbleSize);
        for (int i = 0; i < nb; ++i) {
            points.add(USymbolCloud.rnd(rnd, change.getTrueCoordinate((double)i * length / (double)nb, 0.0), bubbleSize * 0.2));
        }
    }

    private void addCurve(Random rnd, UPath path, Point2D p1, Point2D p2) {
        CoordinateChange change = new CoordinateChange(p1, p2);
        double length = change.getLength();
        double coef = USymbolCloud.rnd(rnd, 0.25, 0.35);
        Point2D middle = change.getTrueCoordinate(length * coef, -length * USymbolCloud.rnd(rnd, 0.4, 0.55));
        Point2D middle2 = change.getTrueCoordinate(length * (1.0 - coef), -length * USymbolCloud.rnd(rnd, 0.4, 0.55));
        path.cubicTo(middle, middle2, p2);
    }

    private static double rnd(Random rnd, double a, double b) {
        return rnd.nextDouble() * (b - a) + a;
    }

    private static Point2D rnd(Random rnd, Point2D pt, double v) {
        double x = pt.getX() + v * rnd.nextDouble();
        double y = pt.getY() + v * rnd.nextDouble();
        return new Point2D.Double(x, y);
    }

    private UPath getSpecificFrontierForCloud(double width, double height) {
        return this.getSpecificFrontierForCloudNew(width, height);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(15.0, 15.0, 15.0, 15.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, USymbolCloud.this.getRectangleStencil(dim), new UStroke());
                ug = symbolContext.apply(ug);
                USymbolCloud.this.drawCloud(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolCloud.this.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimLabel = label.calculateDimension(stringBounder);
                Dimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolCloud.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimStereo, dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                Dimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                USymbolCloud.this.drawCloud(ug, dim.getWidth(), dim.getHeight(), symbolContext.isShadowing());
                Dimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 13.0)));
                Dimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 13.0 + dimStereo.getHeight())));
            }

            @Override
            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(width, height);
            }
        };
    }

    @Override
    public boolean manageHorizontalLine() {
        return true;
    }
}

