/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.mda;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.api.mda.option2.MDADiagram;
import net.sourceforge.plantuml.api.mda.option2.MDAPackage;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.mda.MDAPackageImpl;

public class MDADiagramImpl
implements MDADiagram {
    private final Collection<MDAPackage> packages = new ArrayList<MDAPackage>();

    public static MDADiagram create(String uml) {
        List<BlockUml> blocks = new SourceStringReader(uml).getBlocks();
        if (blocks.size() == 0 && (blocks = new SourceStringReader(uml = "@startuml\n" + uml + "\n@enduml").getBlocks()).size() == 0) {
            return null;
        }
        BlockUml block = blocks.get(0);
        Diagram diagram = block.getDiagram();
        if (diagram instanceof ClassDiagram) {
            return new MDADiagramImpl((ClassDiagram)diagram);
        }
        return null;
    }

    private MDADiagramImpl(ClassDiagram classDiagram) {
        EntityFactory entityFactory = classDiagram.getEntityFactory();
        this.packages.add(new MDAPackageImpl(entityFactory.getRootGroup()));
        for (IGroup group : entityFactory.getGroupsvalues()) {
            this.packages.add(new MDAPackageImpl(group));
        }
    }

    @Override
    public Collection<MDAPackage> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }
}

