/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.objectdiagram;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.NoteLinkStrategy;
import net.sourceforge.plantuml.utils.UniqueSequence;

public abstract class AbstractClassOrObjectDiagram
extends AbstractEntityDiagram {
    private final List<Association> associations = new ArrayList<Association>();

    public final boolean insertBetween(IEntity entity1, IEntity entity2, IEntity node) {
        Link link = this.foundLink(entity1, entity2);
        if (link == null) {
            return false;
        }
        Link l1 = new Link(entity1, node, link.getType(), link.getLabel(), link.getLength(), link.getQualifier1(), null, link.getLabeldistance(), link.getLabelangle());
        Link l2 = new Link(node, entity2, link.getType(), link.getLabel(), link.getLength(), null, link.getQualifier2(), link.getLabeldistance(), link.getLabelangle());
        this.addLink(l1);
        this.addLink(l2);
        this.removeLink(link);
        return true;
    }

    private Link foundLink(IEntity entity1, IEntity entity2) {
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link l = links.get(i);
            if (!l.isBetween(entity1, entity2)) continue;
            return l;
        }
        return null;
    }

    public int getNbOfHozizontalLollipop(IEntity entity) {
        if (entity.getLeafType() == LeafType.LOLLIPOP_FULL || entity.getLeafType() == LeafType.LOLLIPOP_HALF) {
            throw new IllegalArgumentException();
        }
        int result = 0;
        for (Link link : this.getLinks()) {
            if (link.getLength() != 1 || !link.contains(entity) || !link.containsType(LeafType.LOLLIPOP_FULL) && !link.containsType(LeafType.LOLLIPOP_HALF)) continue;
            ++result;
        }
        return result;
    }

    public CommandExecutionResult associationClass(Code clName1A, Code clName1B, Code clName2A, Code clName2B, LinkType linkType, Display label) {
        IEntity entity1A = this.getOrCreateLeaf(clName1A, null, null);
        IEntity entity1B = this.getOrCreateLeaf(clName1B, null, null);
        IEntity entity2A = this.getOrCreateLeaf(clName2A, null, null);
        IEntity entity2B = this.getOrCreateLeaf(clName2B, null, null);
        List<Association> same1 = this.getExistingAssociatedPoints(entity1A, entity1B);
        List<Association> same2 = this.getExistingAssociatedPoints(entity2A, entity2B);
        if (same1.size() == 0 && same2.size() == 0) {
            IEntity point1 = this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
            IEntity point2 = this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
            this.insertPointBetween(entity1A, entity1B, point1);
            this.insertPointBetween(entity2A, entity2B, point2);
            boolean length = true;
            Link point1ToPoint2 = new Link(point1, point2, linkType, label, 1);
            this.addLink(point1ToPoint2);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot link two associations points");
    }

    private void insertPointBetween(IEntity entity1A, IEntity entity1B, IEntity point1) {
        Link existingLink1 = this.foundLink(entity1A, entity1B);
        if (existingLink1 == null) {
            existingLink1 = new Link(entity1A, entity1B, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
        } else {
            this.removeLink(existingLink1);
        }
        IEntity entity1real = existingLink1.isInverted() ? existingLink1.getEntity2() : existingLink1.getEntity1();
        IEntity entity2real = existingLink1.isInverted() ? existingLink1.getEntity1() : existingLink1.getEntity2();
        Link entity1ToPoint = new Link(entity1real, point1, existingLink1.getType().getPart2(), existingLink1.getLabel(), existingLink1.getLength(), existingLink1.getQualifier1(), null, existingLink1.getLabeldistance(), existingLink1.getLabelangle());
        entity1ToPoint.setLinkArrow(existingLink1.getLinkArrow());
        Link pointToEntity2 = new Link(point1, entity2real, existingLink1.getType().getPart1(), Display.NULL, existingLink1.getLength(), null, existingLink1.getQualifier2(), existingLink1.getLabeldistance(), existingLink1.getLabelangle());
        this.addLink(entity1ToPoint);
        this.addLink(pointToEntity2);
    }

    public boolean associationClass(int mode, Code clName1, Code clName2, IEntity associed, LinkType linkType, Display label) {
        IEntity entity2;
        IEntity entity1 = this.getOrCreateLeaf(clName1, null, null);
        List<Association> same = this.getExistingAssociatedPoints(entity1, entity2 = this.getOrCreateLeaf(clName2, null, null));
        if (same.size() > 1) {
            return false;
        }
        if (same.size() == 0) {
            Association association = new Association(mode, entity1, entity2, associed);
            association.createNew(mode, linkType, label);
            this.associations.add(association);
            return true;
        }
        assert (same.size() == 1);
        Association association = same.get(0).createSecondAssociation(mode, associed, label);
        association.createInSecond(linkType, label);
        this.associations.add(association);
        return true;
    }

    private List<Association> getExistingAssociatedPoints(IEntity entity1, IEntity entity2) {
        ArrayList<Association> same = new ArrayList<Association>();
        for (Association existing : this.associations) {
            if (!existing.sameCouple(entity1, entity2)) continue;
            same.add(existing);
        }
        return same;
    }

    @Override
    public void setLegend(DisplayPositionned legend) {
        IGroup currentGroup = this.getCurrentGroup();
        if (currentGroup instanceof GroupRoot) {
            super.setLegend(legend);
            return;
        }
        currentGroup.setLegend(legend);
    }

    class Association {
        private IEntity entity1;
        private IEntity entity2;
        private IEntity associed;
        private IEntity point;
        private Link existingLink;
        private Link entity1ToPoint;
        private Link pointToEntity2;
        private Link pointToAssocied;
        private Association other;

        public Association(int mode, IEntity entity1, IEntity entity2, IEntity associed) {
            this.entity1 = entity1;
            this.entity2 = entity2;
            this.associed = associed;
            this.point = AbstractClassOrObjectDiagram.this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
        }

        public Association createSecondAssociation(int mode2, IEntity associed2, Display label) {
            Association result = new Association(mode2, this.entity1, this.entity2, associed2);
            result.existingLink = this.existingLink;
            result.other = this;
            if (this.existingLink.getLength() == 1) {
                this.entity1ToPoint.setLength(2);
                this.pointToEntity2.setLength(2);
                this.pointToAssocied.setLength(1);
            }
            return result;
        }

        void createNew(int mode, LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            IEntity entity1real = this.existingLink.isInverted() ? this.existingLink.getEntity2() : this.existingLink.getEntity1();
            IEntity entity2real = this.existingLink.isInverted() ? this.existingLink.getEntity1() : this.existingLink.getEntity2();
            this.entity1ToPoint = new Link(entity1real, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), this.existingLink.getLength(), this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.entity1ToPoint.setLinkArrow(this.existingLink.getLinkArrow());
            this.pointToEntity2 = new Link(this.point, entity2real, this.existingLink.getType().getPart1(), Display.NULL, this.existingLink.getLength(), null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            int length = 1;
            if (this.existingLink.getLength() == 1 && this.entity1 != this.entity2) {
                length = 2;
            }
            if (this.existingLink.getLength() == 2 && this.entity1 == this.entity2) {
                length = 2;
            }
            if (length == 1) {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.NORMAL);
            } else {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_PRINTED_FULL);
                this.pointToEntity2.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_NOT_PRINTED);
            }
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            this.pointToAssocied = mode == 1 ? new Link(this.point, this.associed, linkType, label, length) : new Link(this.associed, this.point, linkType, label, length);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
        }

        void createInSecond(LinkType linkType, Display label) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(this.entity1, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), 2, this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.pointToEntity2 = new Link(this.point, this.entity2, this.existingLink.getType().getPart1(), Display.NULL, 2, null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            if (this.other.pointToAssocied.getEntity1().getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
                AbstractClassOrObjectDiagram.this.removeLink(this.other.pointToAssocied);
                this.other.pointToAssocied = this.other.pointToAssocied.getInv();
                AbstractClassOrObjectDiagram.this.addLink(this.other.pointToAssocied);
            }
            this.pointToAssocied = new Link(this.point, this.associed, linkType, label, 1);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
            Link lnode = new Link(this.other.point, this.point, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 1);
            lnode.setInvis(true);
            AbstractClassOrObjectDiagram.this.addLink(lnode);
        }

        boolean sameCouple(IEntity entity1, IEntity entity2) {
            if (this.entity1 == entity1 && this.entity2 == entity2) {
                return true;
            }
            return this.entity1 == entity2 && this.entity2 == entity1;
        }
    }
}

