/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project3;

import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project3.GanttDiagram;
import net.sourceforge.plantuml.project3.Subject;
import net.sourceforge.plantuml.project3.SubjectPattern;
import net.sourceforge.plantuml.project3.Task;
import net.sourceforge.plantuml.project3.VerbEnds;
import net.sourceforge.plantuml.project3.VerbHappens;
import net.sourceforge.plantuml.project3.VerbIsColored;
import net.sourceforge.plantuml.project3.VerbIsDeleted;
import net.sourceforge.plantuml.project3.VerbLasts;
import net.sourceforge.plantuml.project3.VerbPattern;
import net.sourceforge.plantuml.project3.VerbTaskEndsAbsolute;
import net.sourceforge.plantuml.project3.VerbTaskStarts;
import net.sourceforge.plantuml.project3.VerbTaskStartsAbsolute;

public class SubjectTask
implements SubjectPattern {
    @Override
    public Collection<VerbPattern> getVerbs() {
        return Arrays.asList(new VerbLasts(), new VerbTaskStarts(), new VerbTaskStartsAbsolute(), new VerbHappens(), new VerbEnds(), new VerbTaskEndsAbsolute(), new VerbIsColored(), new VerbIsDeleted());
    }

    @Override
    public IRegex toRegex() {
        return new RegexConcat(new RegexLeaf("THEN", "(then[%s]+)?"), new RegexLeaf("SUBJECT", "\\[([^\\[\\]]+?)\\](?:[%s]+as[%s]+\\[([^\\[\\]]+?)\\])?"), new RegexLeaf("RESOURCE", "(?:[%s]+on[%s]+((?:\\{[^{}]+\\}[%s]*)+))?"));
    }

    @Override
    public Subject getSubject(GanttDiagram project, RegexResult arg) {
        String s = arg.get("SUBJECT", 0);
        String shortName = arg.get("SUBJECT", 1);
        String then = arg.get("THEN", 0);
        String resource = arg.get("RESOURCE", 0);
        Task result = project.getOrCreateTask(s, shortName, then != null);
        if (result == null) {
            throw new IllegalStateException();
        }
        if (resource != null) {
            StringTokenizer st = new StringTokenizer(resource, "{}");
            while (st.hasMoreTokens()) {
                String part = st.nextToken().trim();
                if (part.length() <= 0) continue;
                project.affectResource(result, part);
            }
        }
        return result;
    }
}

