/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram;

import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SpecificBackcolorable;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.AbstractEvent;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteStyle;
import net.sourceforge.plantuml.sequencediagram.Participant;

public class Note
extends AbstractEvent
implements Event,
SpecificBackcolorable {
    private final Participant p;
    private final Participant p2;
    private final Display strings;
    private final NotePosition position;
    private NoteStyle style = NoteStyle.NORMAL;
    private Colors colors = Colors.empty();
    private Url url;
    private boolean parallel = false;

    public Note(Participant p, NotePosition position, Display strings) {
        this(p, null, position, strings);
    }

    public Note(Display strings, NotePosition position, NoteStyle style) {
        this(null, null, position, strings);
        this.style = style;
    }

    public Note(Participant p, Participant p2, Display strings) {
        this(p, p2, NotePosition.OVER_SEVERAL, strings);
    }

    private Note(Participant p, Participant p2, NotePosition position, Display strings) {
        this.p = p;
        this.p2 = p2;
        this.position = position;
        this.strings = strings;
    }

    public Note withPosition(NotePosition newPosition) {
        if (this.position == newPosition) {
            return this;
        }
        Note result = new Note(this.p, this.p2, newPosition, this.strings);
        result.style = this.style;
        result.url = this.url;
        result.colors = this.colors;
        result.parallel = this.parallel;
        return result;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public Participant getParticipant2() {
        return this.p2;
    }

    public Display getStrings() {
        return this.strings;
    }

    public NotePosition getPosition() {
        return this.position;
    }

    @Override
    public Colors getColors(ISkinParam skinParam) {
        return this.colors;
    }

    @Override
    public void setColors(Colors colors) {
        this.colors = colors;
    }

    @Override
    public boolean dealWith(Participant someone) {
        return this.p == someone || this.p2 == someone;
    }

    @Override
    public Url getUrl() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        return this.url != null;
    }

    public final NoteStyle getStyle() {
        return this.style;
    }

    public final void setStyle(NoteStyle style) {
        this.style = style;
    }

    public ISkinParam getSkinParamBackcolored(ISkinParam skinParam) {
        return this.colors.mute(skinParam);
    }

    public String toString() {
        return super.toString() + " " + this.strings;
    }

    public void setUrl(Url url) {
        this.url = url;
    }

    public void goParallel() {
        this.parallel = true;
    }

    @Override
    public boolean isParallel() {
        return this.parallel;
    }
}

