/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import java.text.DecimalFormat;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.DottedNumber;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandAutonumber
extends SingleLineCommand2<SequenceDiagram> {
    public CommandAutonumber() {
        super(CommandAutonumber.getConcat());
    }

    private static RegexConcat getConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("autonumber"), new RegexLeaf("[%s]*"), new RegexLeaf("START", "(\\d(?:(?:[^\\p{L}0-9%s]+|\\d+)*\\d)?)?"), new RegexLeaf("STEP", "(?:[%s]+(\\d+))?"), new RegexLeaf("FORMAT", "(?:[%s]+[%g]([^%g]+)[%g])?"), new RegexLeaf("[%s]*"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        DecimalFormat decimalFormat;
        String arg2;
        DottedNumber start = DottedNumber.create("1");
        String arg0 = arg.get("START", 0);
        if (arg0 != null) {
            start = DottedNumber.create(arg0);
        }
        int inc = 1;
        String arg1 = arg.get("STEP", 0);
        if (arg1 != null) {
            inc = Integer.parseInt(arg1);
        }
        String df = (arg2 = arg.get("FORMAT", 0)) == null ? "<b>0</b>" : arg2;
        try {
            decimalFormat = new DecimalFormat(df);
        }
        catch (IllegalArgumentException e) {
            return CommandExecutionResult.error("Error in pattern : " + df);
        }
        diagram.autonumberGo(start, inc, decimalFormat);
        return CommandExecutionResult.ok();
    }
}

