/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandAutonumberIncrement
extends SingleLineCommand2<SequenceDiagram> {
    public CommandAutonumberIncrement() {
        super(CommandAutonumberIncrement.getConcat());
    }

    private static RegexConcat getConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("autonumber"), new RegexLeaf("[%s]+"), new RegexLeaf("inc"), new RegexLeaf("POS", "(?:[%s]+([A-Za-z]))?"), new RegexLeaf("[%s]*"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg) {
        String position = arg.get("POS", 0);
        if (position == null) {
            diagram.getAutoNumber().incrementIntermediate();
        } else {
            int pos = StringUtils.goLowerCase(position.charAt(0)) - 97;
            diagram.getAutoNumber().incrementIntermediate(pos);
        }
        return CommandExecutionResult.ok();
    }
}

