/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

public class CommandBoxStart
extends SingleLineCommand2<SequenceDiagram> {
    public CommandBoxStart() {
        super(CommandBoxStart.getRegexConcat());
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("box"), new RegexOptional((IRegex)new RegexOr(new RegexLeaf("NAME1", "[%s]+[%g]([^%g]+)[%g]"), new RegexLeaf("NAME2", "[%s]+([^#]+)"))), new RegexLeaf("[%s]*"), CommandBoxStart.color().getRegex(), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram diagram, LineLocation location, RegexResult arg2) {
        if (diagram.isBoxPending()) {
            return CommandExecutionResult.error("Box cannot be nested");
        }
        String argTitle = arg2.getLazzy("NAME", 0);
        String argColor = arg2.get("COLOR", 0);
        Colors colors = CommandBoxStart.color().getColor(arg2, diagram.getSkinParam().getIHtmlColorSet());
        String title = argTitle == null ? "" : argTitle;
        diagram.boxStart(Display.getWithNewlines(title), colors.getColor(ColorType.BACK));
        return CommandExecutionResult.ok();
    }
}

