/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.sequencediagram.EventWithDeactivate;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.skin.ArrowBody;
import net.sourceforge.plantuml.skin.ArrowConfiguration;

public class CommandReturn
extends SingleLineCommand2<SequenceDiagram> {
    public CommandReturn() {
        super(CommandReturn.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PARALLEL", "(&%s*)?"), new RegexLeaf("[%s]*"), new RegexLeaf("return[%s]*"), new RegexLeaf("COLOR", "(?:(#\\w+)[%s]+)?"), new RegexLeaf("MESSAGE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, LineLocation location, RegexResult arg) {
        String error;
        boolean parallel;
        Message message1 = sequenceDiagram.getActivatingMessage();
        boolean doDeactivation = true;
        if (message1 == null) {
            EventWithDeactivate last = sequenceDiagram.getLastEventWithDeactivate();
            if (!(last instanceof Message)) {
                return CommandExecutionResult.error("Nowhere to return to.");
            }
            message1 = (Message)last;
            doDeactivation = false;
        }
        ArrowConfiguration arrow = message1.getArrowConfiguration().withBody(ArrowBody.DOTTED);
        String color = arg.get("COLOR", 0);
        if (color != null) {
            arrow = arrow.withColor(HtmlColorSet.getInstance().getColorIfValid(color));
        }
        Display display = Display.getWithNewlines(arg.get("MESSAGE", 0));
        Message message2 = new Message(message1.getParticipant2(), message1.getParticipant1(), display, arrow, sequenceDiagram.getNextMessageNumber());
        boolean bl = parallel = arg.get("PARALLEL", 0) != null;
        if (parallel) {
            message2.goParallel();
        }
        sequenceDiagram.addMessage(message2);
        if (doDeactivation && (error = sequenceDiagram.activate(message1.getParticipant2(), LifeEventType.DEACTIVATE, null)) != null) {
            return CommandExecutionResult.error(error);
        }
        return CommandExecutionResult.ok();
    }
}

