/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class TileParallel
implements Tile,
TileWithUpdateStairs,
TileWithCallbackY {
    private final List<Tile> tiles = new ArrayList<Tile>();

    @Override
    public void callbackY(double y) {
        for (Tile tile : this.tiles) {
            if (!(tile instanceof TileWithCallbackY)) continue;
            ((TileWithCallbackY)tile).callbackY(y);
        }
    }

    @Override
    public void updateStairs(StringBounder stringBounder, double y) {
        for (Tile tile : this.tiles) {
            if (!(tile instanceof TileWithUpdateStairs)) continue;
            ((TileWithUpdateStairs)tile).updateStairs(stringBounder, y);
        }
    }

    public void add(Tile tile) {
        this.tiles.add(tile);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        double yPointAll = this.getYPoint(stringBounder);
        for (Tile tile : this.tiles) {
            double yPoint = tile.getYPoint(stringBounder);
            tile.drawU(ug.apply(new UTranslate(0.0, yPointAll - yPoint)));
        }
    }

    @Override
    public double getYPoint(StringBounder stringBounder) {
        double result = 0.0;
        for (Tile tile : this.tiles) {
            result = Math.max(result, tile.getYPoint(stringBounder));
        }
        return result;
    }

    @Override
    public double getZ(StringBounder stringBounder) {
        double result = 0.0;
        for (Tile tile : this.tiles) {
            result = Math.max(result, tile.getZ(stringBounder));
        }
        return result;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getYPoint(stringBounder) + this.getZ(stringBounder);
    }

    @Override
    public void addConstraints(StringBounder stringBounder) {
        for (Tile tile : this.tiles) {
            tile.addConstraints(stringBounder);
        }
    }

    @Override
    public Real getMinX(final StringBounder stringBounder) {
        return RealUtils.min((Collection<Real>)new AbstractCollection<Real>(){

            @Override
            public Iterator<Real> iterator() {
                return new Iterator<Real>(){
                    private final Iterator<Tile> source;
                    {
                        this.source = TileParallel.this.tiles.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.source.hasNext();
                    }

                    @Override
                    public Real next() {
                        return this.source.next().getMinX(stringBounder);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return TileParallel.this.tiles.size();
            }
        });
    }

    @Override
    public Real getMaxX(final StringBounder stringBounder) {
        return RealUtils.max((Collection<Real>)new AbstractCollection<Real>(){

            @Override
            public Iterator<Real> iterator() {
                return new Iterator<Real>(){
                    private final Iterator<Tile> source;
                    {
                        this.source = TileParallel.this.tiles.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.source.hasNext();
                    }

                    @Override
                    public Real next() {
                        return this.source.next().getMaxX(stringBounder);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return TileParallel.this.tiles.size();
            }
        });
    }

    @Override
    public Event getEvent() {
        return null;
    }
}

