/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTile;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class YPositionedTile {
    private final Tile tile;
    private final double y;

    public boolean inArea(double ymin, double ymax) {
        return this.y >= ymin && this.y < ymax;
    }

    public YPositionedTile(Tile tile, double y) {
        this.tile = tile;
        this.y = y;
        if (tile instanceof TileWithCallbackY) {
            ((TileWithCallbackY)tile).callbackY(y);
        }
    }

    public String toString() {
        return "y=" + this.y + " " + this.tile;
    }

    public void drawInArea(UGraphic ug) {
        ug.apply(new UTranslate(0.0, this.y)).draw(this.tile);
    }

    public boolean matchAnchor(String anchor) {
        AbstractMessage msg;
        Event event = this.tile.getEvent();
        return event instanceof AbstractMessage && anchor.equals((msg = (AbstractMessage)event).getAnchor());
    }

    public final double getY(StringBounder stringBounder) {
        CommunicationTile communicationTile = (CommunicationTile)this.tile;
        return this.y + communicationTile.getYPoint(stringBounder);
    }

    public double getMiddleX(StringBounder stringBounder) {
        double max = this.tile.getMaxX(stringBounder).getCurrentValue();
        double min = this.tile.getMinX(stringBounder).getCurrentValue();
        return (min + max) / 2.0;
    }
}

