/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.LineBreakStrategy;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseDatabase
extends AbstractTextualComponent {
    private final TextBlock stickman;
    private final boolean head;

    public ComponentRoseDatabase(SymbolContext biColor, FontConfiguration font, Display stringsToDisplay, boolean head, ISkinSimple spriteContainer, UFont fontForStereotype, HtmlColor htmlColorForStereotype) {
        super(LineBreakStrategy.NONE, stringsToDisplay, font, HorizontalAlignment.CENTER, 3, 3, 0, spriteContainer, false, fontForStereotype, htmlColorForStereotype);
        this.head = head;
        SymbolContext symbolContext = new SymbolContext(biColor.getBackColor(), biColor.getForeColor()).withStroke(new UStroke(1.5)).withShadow(biColor.getDeltaShadow() > 0.0);
        this.stickman = USymbol.DATABASE.asSmall(null, TextBlockUtils.empty(16.0, 17.0), TextBlockUtils.empty(0.0, 0.0), symbolContext, HorizontalAlignment.CENTER);
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        double delta = (this.getPreferredWidth(stringBounder) - dimStickman.getWidth()) / 2.0;
        if (this.head) {
            textBlock.drawU(ug.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), dimStickman.getHeight())));
            ug = ug.apply(new UTranslate(delta, 0.0));
        } else {
            textBlock.drawU(ug.apply(new UTranslate(this.getTextMiddlePostion(stringBounder), 0.0)));
            ug = ug.apply(new UTranslate(delta, this.getTextHeight(stringBounder)));
        }
        this.stickman.drawU(ug);
    }

    private double getTextMiddlePostion(StringBounder stringBounder) {
        return (this.getPreferredWidth(stringBounder) - this.getTextWidth(stringBounder)) / 2.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return dimStickman.getHeight() + this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        Dimension2D dimStickman = this.stickman.calculateDimension(stringBounder);
        return Math.max(dimStickman.getWidth(), this.getTextWidth(stringBounder));
    }
}

