/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.tim.Eater;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunctionImpl;
import net.sourceforge.plantuml.tim.TMemory;

public class EaterDeclareFunction
extends Eater {
    private TFunctionImpl function;
    private final LineLocation location;
    private boolean finalFlag;

    public EaterDeclareFunction(StringLocated s) {
        super(s.getStringTrimmed());
        this.location = s.getLocation();
    }

    @Override
    public void execute(TContext context, TMemory memory) throws EaterException {
        this.skipSpaces();
        this.checkAndEatChar("!");
        boolean unquoted = false;
        while (this.peekUnquoted() || this.peekFinal()) {
            if (this.peekUnquoted()) {
                this.checkAndEatChar("unquoted");
                this.skipSpaces();
                unquoted = true;
                continue;
            }
            if (!this.peekFinal()) continue;
            this.checkAndEatChar("final");
            this.skipSpaces();
            this.finalFlag = true;
        }
        this.checkAndEatChar("function");
        this.skipSpaces();
        this.function = this.eatDeclareFunctionWithOptionalReturn(context, memory, unquoted, this.location);
    }

    private boolean peekUnquoted() {
        return this.peekChar() == 'u';
    }

    private boolean peekFinal() {
        return this.peekChar() == 'f' && this.peekCharN2() == 'i';
    }

    public TFunctionImpl getFunction() {
        return this.function;
    }

    public final boolean getFinalFlag() {
        return this.finalFlag;
    }
}

