/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.tim.ConditionalContexts;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryLocal;
import net.sourceforge.plantuml.tim.TVariable;
import net.sourceforge.plantuml.tim.TVariableScope;
import net.sourceforge.plantuml.tim.Trie;
import net.sourceforge.plantuml.tim.expression.TValue;

public class TMemoryGlobal
extends ConditionalContexts
implements TMemory {
    private final Map<String, TVariable> globalVariables = new HashMap<String, TVariable>();
    private final Trie variables = new Trie();

    @Override
    public TVariable getVariable(String varname) {
        return this.globalVariables.get(varname);
    }

    @Override
    public void dumpDebug(String message) {
        Log.error("[MemGlobal] Start of memory_dump " + message);
        this.dumpMemoryInternal();
        Log.error("[MemGlobal] End of memory_dump");
    }

    void dumpMemoryInternal() {
        Log.error("[MemGlobal] Number of variable(s) : " + this.globalVariables.size());
        for (Map.Entry<String, TVariable> ent : new TreeMap<String, TVariable>(this.globalVariables).entrySet()) {
            String name = ent.getKey();
            TValue value = ent.getValue().getValue2();
            Log.error("[MemGlobal] " + name + " = " + value);
        }
    }

    @Override
    public void putVariable(String varname, TVariable value, TVariableScope scope) throws EaterException {
        Log.info("[MemGlobal] Setting " + varname);
        if (scope == TVariableScope.LOCAL) {
            throw new EaterException("Cannot use local variable here");
        }
        this.globalVariables.put(varname, value);
        this.variables.add(varname);
    }

    @Override
    public void removeVariable(String varname) {
        this.globalVariables.remove(varname);
        this.variables.remove(varname);
    }

    @Override
    public boolean isEmpty() {
        return this.globalVariables.isEmpty();
    }

    @Override
    public Set<String> variablesNames() {
        return Collections.unmodifiableSet(this.globalVariables.keySet());
    }

    @Override
    public Trie variablesNames3() {
        return this.variables;
    }

    @Override
    public TMemory forkFromGlobal(Map<String, TVariable> input) {
        return new TMemoryLocal(this, input);
    }
}

