/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.tim.ConditionalContexts;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.TMemoryGlobal;
import net.sourceforge.plantuml.tim.TVariable;
import net.sourceforge.plantuml.tim.TVariableScope;
import net.sourceforge.plantuml.tim.Trie;
import net.sourceforge.plantuml.tim.expression.TValue;

public class TMemoryLocal
extends ConditionalContexts
implements TMemory {
    private final TMemoryGlobal memoryGlobal;
    private final Map<String, TVariable> overridenVariables = new HashMap<String, TVariable>();
    private final Map<String, TVariable> localVariables = new HashMap<String, TVariable>();

    public TMemoryLocal(TMemoryGlobal global, Map<String, TVariable> input) {
        this.memoryGlobal = global;
        this.overridenVariables.putAll(input);
    }

    @Override
    public void dumpDebug(String message) {
        TValue value;
        String name;
        Log.error("[MemLocal] Start of memory_dump " + message);
        this.memoryGlobal.dumpMemoryInternal();
        Log.error("[MemLocal] Number of overriden variable(s) : " + this.overridenVariables.size());
        for (Map.Entry<String, TVariable> ent : new TreeMap<String, TVariable>(this.overridenVariables).entrySet()) {
            name = ent.getKey();
            value = ent.getValue().getValue2();
            Log.error("[MemLocal] " + name + " = " + value);
        }
        Log.error("[MemLocal] Number of local variable(s) : " + this.localVariables.size());
        for (Map.Entry<String, TVariable> ent : new TreeMap<String, TVariable>(this.localVariables).entrySet()) {
            name = ent.getKey();
            value = ent.getValue().getValue2();
            Log.error("[MemLocal] " + name + " = " + value);
        }
        Log.error("[MemGlobal] End of memory_dump");
    }

    @Override
    public void putVariable(String varname, TVariable value, TVariableScope scope) throws EaterException {
        if (scope == TVariableScope.GLOBAL) {
            this.memoryGlobal.putVariable(varname, value, scope);
            return;
        }
        if (scope == TVariableScope.LOCAL || this.overridenVariables.containsKey(varname)) {
            this.overridenVariables.put(varname, value);
            Log.info("[MemLocal/overrriden] Setting " + varname);
        } else if (this.memoryGlobal.getVariable(varname) != null) {
            this.memoryGlobal.putVariable(varname, value, scope);
        } else {
            this.localVariables.put(varname, value);
            Log.info("[MemLocal/local] Setting " + varname);
        }
    }

    @Override
    public void removeVariable(String varname) {
        if (this.overridenVariables.containsKey(varname)) {
            this.overridenVariables.remove(varname);
        } else if (this.memoryGlobal.getVariable(varname) != null) {
            this.memoryGlobal.removeVariable(varname);
        } else {
            this.localVariables.remove(varname);
        }
    }

    @Override
    public TVariable getVariable(String varname) {
        TVariable result = this.overridenVariables.get(varname);
        if (result != null) {
            return result;
        }
        result = this.memoryGlobal.getVariable(varname);
        if (result != null) {
            return result;
        }
        result = this.localVariables.get(varname);
        return result;
    }

    @Override
    public Trie variablesNames3() {
        Trie result = new Trie();
        for (String name : this.overridenVariables.keySet()) {
            result.add(name);
        }
        for (String name : this.memoryGlobal.variablesNames()) {
            result.add(name);
        }
        for (String name : this.localVariables.keySet()) {
            result.add(name);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.memoryGlobal.isEmpty() && this.localVariables.isEmpty() && this.overridenVariables.isEmpty();
    }

    @Override
    public Set<String> variablesNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TMemory forkFromGlobal(Map<String, TVariable> input) {
        return new TMemoryLocal(this.memoryGlobal, input);
    }
}

