/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.CommandChangeState;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandChangeStateByPlayerCode
extends CommandChangeState {
    public CommandChangeStateByPlayerCode() {
        super(CommandChangeStateByPlayerCode.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("CODE", "([\\p{L}_][\\p{L}0-9_.]*)"), new RegexLeaf("[%s]*is[%s]*"), CommandChangeStateByPlayerCode.getStateOrHidden(), new RegexLeaf("[%s]*"), CommandChangeStateByPlayerCode.color().getRegex(), new RegexLeaf("[%s]*"), new RegexLeaf("COMMENT", "(?:[%s]*:[%s]*(.*?))?"), new RegexLeaf("[%s]*$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        String code = arg.get("CODE", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("Unkown \"" + code + "\"");
        }
        TimeTick now = diagram.getNow();
        return this.addState(diagram, arg, player, now);
    }
}

