/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimeTick;
import net.sourceforge.plantuml.timingdiagram.TimeTickBuilder;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;

public class CommandConstraint
extends SingleLineCommand2<TimingDiagram> {
    public CommandConstraint() {
        super(CommandConstraint.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("PART1", "(([\\p{L}_][\\p{L}0-9_.]*))?"), TimeTickBuilder.expressionAtWithArobase("TIME1"), new RegexLeaf("[%s]*"), new RegexLeaf("ARROW", "\\<(-+)\\>"), new RegexLeaf("[%s]*"), TimeTickBuilder.expressionAtWithArobase("TIME2"), new RegexLeaf("[%s]*"), new RegexLeaf("MESSAGE", "(?::[%s]*(.*))?"), new RegexLeaf("[%s]*$"));
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg) {
        Player player1;
        String part1 = arg.get("PART1", 0);
        if (part1 == null) {
            player1 = diagram.getLastPlayer();
            if (player1 == null) {
                return CommandExecutionResult.error("You have to provide a participant");
            }
        } else {
            player1 = diagram.getPlayer(part1);
        }
        TimeTick tick1 = TimeTickBuilder.parseTimeTick("TIME1", arg, diagram);
        diagram.updateNow(tick1);
        TimeTick tick2 = TimeTickBuilder.parseTimeTick("TIME2", arg, diagram);
        player1.createConstraint(tick1, tick2, arg.get("MESSAGE", 0));
        return CommandExecutionResult.ok();
    }
}

