/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.wbs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.mindmap.IdeaShape;

class WElement {
    private final Display label;
    private final int level;
    private final WElement parent;
    private final List<WElement> childrenLeft = new ArrayList<WElement>();
    private final List<WElement> childrenRight = new ArrayList<WElement>();
    private final IdeaShape shape;

    public WElement(Display label) {
        this(label, 0, null, IdeaShape.BOX);
    }

    private WElement(Display label, int level, WElement parent, IdeaShape shape) {
        this.label = label;
        this.level = level;
        this.parent = parent;
        this.shape = shape;
    }

    public boolean isLeaf() {
        return this.childrenLeft.size() == 0 && this.childrenRight.size() == 0;
    }

    public WElement createElement(int newLevel, Display newLabel, Direction direction, IdeaShape shape) {
        WElement result = new WElement(newLabel, newLevel, this, shape);
        if (direction == Direction.LEFT) {
            this.childrenLeft.add(result);
        } else {
            this.childrenRight.add(result);
        }
        return result;
    }

    public String toString() {
        return this.label.toString();
    }

    public final int getLevel() {
        return this.level;
    }

    public final Display getLabel() {
        return this.label;
    }

    public Collection<WElement> getChildren(Direction direction) {
        if (direction == Direction.LEFT) {
            return Collections.unmodifiableList(this.childrenLeft);
        }
        return Collections.unmodifiableList(this.childrenRight);
    }

    public WElement getParent() {
        return this.parent;
    }

    public final IdeaShape getShape() {
        return this.shape;
    }
}

