# MPU6050 by Electronic Cats - Library for Arduino

<a href="https://github.com/ElectronicCats/mpu6050/wiki">
  <img src="https://user-images.githubusercontent.com/107638696/241324971-43b8fe88-447d-4c2d-9296-4b3aaa50f4ce.png" height="400" />
</a>

<p>
<a href="https://github.com/ElectronicCats/mpu6050/wiki">
  <img src="https://github.com/ElectronicCats/mpu6050/assets/139595394/62f14865-5e11-4c83-a044-f63a2ddbeb23" />
</a>
</p>

[![LibraryBuild](https://github.com/ElectronicCats/mpu6050/actions/workflows/LibraryBuild.yml/badge.svg)](https://github.com/ElectronicCats/mpu6050/actions/workflows/LibraryBuild.yml)

Arduino library for controlling MPU6050 module.

MPU6050 Combines a 3-axis gyroscope and a 3-axis accelerometer on the same silicon die together with
an onboard Digital Motion Processor(DMP) which processes complex 6-axis MotionFusion algorithms.

## Features of this version

- ### Supported Chipsets
  - AVR
  - SAM
  - SAMD21 
  - ARM
  - ESP32 
  - ESP8266
  - RENESAS
  

#### Original Library

Based in the work of [jrowberg/i2cdevlib](https://github.com/jrowberg/i2cdevlib/tree/master/Arduino/MPU6050)

## Quick Installing

To install, use the [Arduino Library Manager](https://support.arduino.cc/hc/en-us/articles/5145457742236-Add-libraries-to-Arduino-IDE) and search for "MPU6050" and install the MPU6050 by Electronic Cats library.


## Maintainer

<a href="https://github.com/sponsors/ElectronicCats">
 <p align="center">
  <img src="https://electroniccats.com/wp-content/uploads/2020/07/Badge_GHS.png" height="104" />
 </p>
</a>

Electronic Cats invests time and resources providing this open source design, please support Electronic Cats and open-source hardware by purchasing products from Electronic Cats!
