#!/bin/bash
## Invoke from project root, e.g Documentation/doxygen.sh

# Generate doxygen file for Raspberry Pi configure command
echo -e "/**\n * @defgroup RaspberryPiGateway Raspberry Pi Gateway\n * @ingroup MyConfigGrp\n * @brief Configuration options for the Raspberry Pi Gateway\n@{\n@verbatim" > configure.h
./configure --help >> configure.h
echo -e "@endverbatim\n@}*/\n" >> configure.h

# Generate version information
export PROJECTNUMBER=$(git fetch --tags; git describe --tags;)

# Generate any UML diagrams in the code tree that has the proper tags
export PLANTUML_JAR_PATH=Documentation/plantuml.jar
java -Djava.awt.headless=true -jar $PLANTUML_JAR_PATH -failfast2 -nbthread auto -o "$PWD/Documentation/img" "./**.(c|cpp|dox|h|hpp|ino)"

# Launch Doxygen (assumed to be in the PATH)
doxygen

# Show any warnings created
cat doxygen.log

# Clean up autogenerated (temporary) artifacts
rm configure.h
