/* Arduino DigitalIO Library
 * Copyright (C) 2013 by William Greiman
 *
 * This file is part of the Arduino DigitalIO Library
 *
 * This Library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the Arduino DigitalIO Library.  If not, see
 * <http://www.gnu.org/licenses/>.
 */
/**
 * @file
 * @brief Fast Digital I/O functions
 *
 */
#ifndef DigitalIO_h
#define DigitalIO_h 1
//------------------------------------------------------------------------------
/** DigitalPin version YYYYMMDD */
#define DIGITAL_IO_VERSION 20151127
//------------------------------------------------------------------------------
#include "DigitalPin.h"
#include "I2cConstants.h"
#include "PinIO.h"
#include "SoftI2cMaster.h"
#include "SoftSPI.h"
#endif  // DigitalIO_h
