// ZPHS01B Multiple Sensor Library
// Mining Plus 2024
// Developed by Nicolas Carvajal
// Ask desarrollo@miningplus.cl

#include "ZPHS01B.h"

static const byte ASKDATA[9] = {
	0xFF,	// head
	0x01,	// reserved
	0x86,	// command read
	0x00,	// reserved
	0x00,	// reserved
	0x00,	// reserved
	0x00,	// reserved
	0x00,	// reserved
	0x79,	// check value
};

ZPHS01B::ZPHS01B(void) {

}

// --------------------------------------------------------
// ZPHS01B:read
// --------------------------------------------------------
int ZPHS01B::read(float *p1, float *p25, float *p10, float *co2, float *voc, float *temp, float *hum, float *ch2o, float *co, float *o3, float *no2) {
	byte buffer;
	int value;
	int len = 0;

    //Variables, sumandos enteros
	int pm1_s=0;
    int pm25_s=0;
    int pm10_s=0;
    int co2_s=0;
    int voc_s=0;
    int temp_s=0;
    int hum_s=0;
    int ch2o_s=0;
    int co_s=0;
    int o3_s=0;
    int no2_s=0;
    // Fin Variables

	int checksum_is;
	int checksum_ok = 0;
	int error = 1;
	int bp = 1;
	while ((sensor_data->available() > 0) && (sensor_data->available() >= (26-len))) {
		buffer = sensor_data->read();
		value = int(buffer);
		switch (len) {
			case (0): if (value != 255) { len = -1; }; break; //Verifica encabezado FF
			case (1): if (value != 134) { len = -1; }; checksum_is = value; break; //Verifica encabezado 86
            case (2): pm1_s = (value << 8); checksum_is += value; break;
            case (3): pm1_s += value; checksum_is += value; break;
            case (4): pm25_s = (value << 8); checksum_is += value; break;
            case (5): pm25_s += value; checksum_is += value; break;
            case (6): pm10_s = (value << 8); checksum_is += value; break;
            case (7): pm10_s += value; checksum_is += value; break;
            case (8): co2_s = (value << 8); checksum_is += value; break;
            case (9): co2_s += value; checksum_is += value; break;
            case (10): voc_s = value; checksum_is += value; break;
            case (11): temp_s = (value << 8); checksum_is += value; break;
            case (12): temp_s += value; checksum_is += value; break;
            case (13): hum_s = (value << 8); checksum_is += value; break;
            case (14): hum_s += value; checksum_is += value; break;
            case (15): ch2o_s = (value << 8); checksum_is += value; break;
            case (16): ch2o_s += value; checksum_is += value; break;
            case (17): co_s = (value << 8); checksum_is += value; break;
            case (18): co_s += value; checksum_is += value; break;
            case (19): o3_s = (value << 8); checksum_is += value; break;
            case (20): o3_s += value; checksum_is += value; break;
            case (21): no2_s = (value << 8); checksum_is += value; break;
            case (22): no2_s += value; checksum_is += value; break;
            case (23): checksum_is += value; break;
            case (24): checksum_is += value; break;
            case (25): if (value == (256-(checksum_is % 256))) { checksum_ok = 1; } else { len = -1; }; break;
            //case (25): checksum_ok = 1; break;
		}
		len++;
		if (len == 26 && checksum_ok == 1) {
			*p1 = (float)pm1_s; *p25 = (float)pm25_s; *p10 = (float)pm10_s; *co2 = (float)co2_s;
            *voc = (float)voc_s; *temp = (float) (temp_s-500)*0.1; *hum = (float) (hum_s);
            *ch2o = (float) ch2o_s*0.001; *co = (float) co_s*0.1; *o3 = (float) o3_s*0.01; *no2 = (float) no2_s*0.01;
			len = 0; checksum_ok = 0; pm1_s = 0; pm25_s=0; pm10_s=0; co2_s=0; voc_s=0; temp_s=0; hum_s=0;
            ch2o_s=0; co_s=0; o3_s=0; no2_s=0; checksum_is = 0;
			error = 0;
		}
		yield();
	}
	return error;
}

// --------------------------------------------------------
// ZPHS01B:query
// --------------------------------------------------------
void ZPHS01B::query() {
	for (uint8_t i = 0; i < 9; i++) {
		sensor_data->write(ASKDATA[i]);
	}
	sensor_data->flush();
	//while (sensor_data->available() > 0) {
	//	sensor_data->read();
	//}
}

#ifndef ESP32
void ZPHS01B::begin(uint8_t pin_rx, uint8_t pin_tx) {
	_pin_rx = pin_rx;
	_pin_tx = pin_tx;

	SoftwareSerial *softSerial = new SoftwareSerial(_pin_rx, _pin_tx);

	softSerial->begin(9600);

	sensor_data = softSerial;
}
#endif

void ZPHS01B::begin(HardwareSerial* serial) {
	serial->begin(9600);
	sensor_data = serial;
}

#ifndef ESP32
void ZPHS01B::begin(SoftwareSerial* serial) {
	serial->begin(9600);
	sensor_data = serial;
}
#endif