// ZPHS01B Multiple Sensor Library
// Mining Plus 2024
// Developed by Nicolas Carvajal
// Ask desarrollo@miningplus.cl

#if ARDUINO >= 100
	#include "Arduino.h"
#else
	#include "WProgram.h"
#endif

#ifndef ESP32
    #include <SoftwareSerial.h>
#endif

class ZPHS01B {
	public:
		ZPHS01B(void);
		void begin(HardwareSerial* serial);
#ifndef ESP32
		void begin(SoftwareSerial* serial);
		void begin(uint8_t pin_rx, uint8_t pin_tx);
#endif
		int read(float *p1, float *p25, float *p10, float *co2, float *voc, float *temp, float *hum, float *ch2o, float *co, float *o3, float *no2);
		void query();
		//void wakeup();
	private:
		uint8_t _pin_rx, _pin_tx;
		Stream *sensor_data;
};
