#!/usr/bin/python3

#def check_equipo():
import subprocess
import requests
import json
import traceback
import sqlite3
import sys

usb_rs485 = ["0403:6001"]
usb_nano = ["1a86:7523","0403:6001"]
usb_gps = ["1546:01a7","1546:01a8"]
out_usb=subprocess.check_output("lsusb").decode()

FINAL_REPORT = {
    'machine_id': 0,               # find out
    'machine_name': 'WAT',         # find out
    'problems_found_last_time': 0, # ask mother about the last time we checked
    'last_check_date': '',         # ask mother about the last time we checked
    'problems_found': 0,           # anything > 0 is bad
    'details': {
        'rc_local': {},
        'services': {},
        'hardware': {}}}

class c:
    HEADER = '\033[95m'
    OKBLUE = '\033[94m'
    OKCYAN = '\033[96m'
    OK = '\033[92m'
    GREEN = '\033[92m'
    WARNING = '\033[93m'
    FAIL = '\033[91m'
    RED = '\033[91m'
    ENDC = '\033[0m'
    BOLD = '\033[1m'
    UNDERLINE = '\033[4m'


def check_equipo():

    def red(msg):
        return c.RED + msg + c.ENDC

    def green(msg):
        return c.GREEN + msg + c.ENDC

    def blue(msg):
        return c.OKBLUE + msg + c.ENDC

    def warning(msg):
        return c.WARNING + msg + c.ENDC

    def getProductName():
        data = subprocess.check_output(["machinename"])
        return data.decode()

    def getProductId():
        data = subprocess.check_output(["machineid"])
        return int(data.decode())
    
    def check_gps_config():
        CONFIG_SOURCE = "/srv/datalogger_ecom/config_ecom.json"
        try:
            config_file=open(CONFIG_SOURCE,'r')
            config=json.load(config_file)
            gps_model = config["GPS_SENSOR"]["MODEL"]
            #print(f"GPS configurado: {gps_model}\n")
        except FileNotFoundError:
            print(warning("No se encontro el archivo de configuracion: %s" % CONFIG_SOURCE))
        return gps_model
 

    # description: Descripcion del atributo buscado
    # command: Comando ejecutado, cuyas lineas de salida seran procesadas
    # pattern: Patron de texto buscado en la salida de command
    # idealcount: Numero de coincidencias que uno espera encontrar




    def check(nombre, id, cantidad=1):
        found = False
        if nombre=="Arduino Nano":
            json_title="arduino"
            js=1
            error_msg = "  - No encuentro %s, y deberia haber %d" % (nombre, cantidad)
        elif nombre=="GPS":
            json_title="gps"
            js=1
            error_msg = "  - No encuentro %s, y deberia haber %d, verifica si esta bien configurado el GPS con el comando gps" % (nombre, cantidad)
        else:
            js=0
        global FINAL_REPORT
        out_usb = subprocess.check_output('lsusb')
        lines=out_usb.decode().split("\n")
        cont=0
        #print(lines)
        for ID in id:
            for linea in lines:
                if ID in linea:
                    cont=cont+1

        if cont == 0:
            if js==1:
                FINAL_REPORT['details']['hardware'][json_title] = {"ok": False, "found": len(lines), "should_have": cantidad}
                FINAL_REPORT['problems_found'] += 1
            print(red(error_msg))
        else:
            found = True
            print("  - Encontre %d %s:" % (cont, nombre))


        if cont == cantidad:
            if js==1:
                FINAL_REPORT['details']['hardware'][json_title] = {"ok": True, "found": cont, "should_have": cantidad}
            print(green("    %d de %d %s encontrados, OK" % (cont, cantidad, nombre)))
        else:
            if cont < cantidad:
                if js==1:
                    FINAL_REPORT['details']['hardware'][json_title] = {"ok": False, "found": cont, "should_have": cantidad}
                    FINAL_REPORT['problems_found'] += 1
                print(red("    %d de %d %s encontrados, algo anda mal" % (cont, cantidad, nombre)))
        return found


    def diskUsage():
        result = subprocess.check_output("df")
        for line in result.decode().split("\n"):
            if "/dev/root" in line:
                data = ' '.join(line.split()).split(' ')[4]
                return data

    def stringFoundInFile(json_title, str, filename, output_if_found, output_if_not_found):
        global FINAL_REPORT
        with open(filename) as myfile:
            found = False
            for line in myfile:
                if not found and str in line:
                    found = True
            if found:
                FINAL_REPORT['details']['rc_local'][json_title] = True
                return "%s" % output_if_found
            else:
                FINAL_REPORT['details']['rc_local'][json_title] = False
                return "%s" % output_if_not_found

    def serviceStatus(service_name):
        global FINAL_REPORT
        try:
            result = subprocess.check_output(
                ["systemctl", "status", service_name],
                stderr=subprocess.STDOUT)
            stdout = result.decode()
        except Exception as exc:
            stdout = exc.output.decode()
            #print("Exception: %s" % exc)

        for line in stdout.split("\n"):
            if "Active: active (running)" in line:
                FINAL_REPORT['details']['services'][service_name] = True
                return green("Instalado y corriendo")
            if "Active: inactive (dead)" in line:
                FINAL_REPORT['details']['services'][service_name] = False
                FINAL_REPORT['problems_found'] += 1
                return warning("Instalado, no esta corriendo")
            if "could not be found" in line:
                FINAL_REPORT['details']['services'][service_name] = None
                FINAL_REPORT['problems_found'] += 1
                return red("No existe")

    def serviceStatus2(service_name):
        global FINAL_REPORT
        try:
            result = subprocess.check_output(
                ["systemctl", "status", service_name],
                stderr=subprocess.STDOUT)
            stdout = result.decode()
        except Exception as exc:
            stdout = exc.output.decode()

        for line in stdout.split("\n"):
            if "Active: active (running)" or "Active: active (auto-restart)" in line:
                FINAL_REPORT['details']['services'][service_name] = True
                return green("Instalado y corriendo")
            if "Active: inactive (dead)" in line:
                FINAL_REPORT['details']['services'][service_name] = False
                FINAL_REPORT['problems_found'] += 1
                return warning("Instalado, no esta corriendo")
            if "could not be found" in line:
                FINAL_REPORT['details']['services'][service_name] = None
                FINAL_REPORT['problems_found'] += 1
                return red("No existe")

    def sqliteQuery(sql, db_path):
        rows = None
        try:
            conn = sqlite3.connect(database=db_path) 
            cur = conn.cursor()
            query = sql
            cur.execute(query)
            rows = cur.fetchall()
            conn.close()
            return rows[0][0]

        except Exception:
            print("mysqlQuery FAILED: %s" % sql)
            e = sys.exc_info()
            print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])
 


    
    # Main
    print("")
    print(green("EVALUACION DE ECOM MINING [ %s ], id %d" % (getProductName(), getProductId())))
    print("-----------------------------------------------------")

    disk_usage = diskUsage()
    localdb_records = int(sqliteQuery("select count(id) from ecom_data", "/srv/datalogger_ecom/database/database.db"))
    print("- Consumo de almacenamiento interno: %s utilizado" % disk_usage)
    print("- Tabla ecom_data en BD local contiene: %d registros" % localdb_records)

    FINAL_REPORT['machine_id'] = getProductId()
    FINAL_REPORT['machine_name'] = getProductName()
    FINAL_REPORT['details']['storage'] = {
        'disk_usage': disk_usage,
        'localdb_records': localdb_records,
    }


    # ------
    print("")
    print(blue("- Revisando /etc/rc.local"))
    # print(stringFoundInFile(
    # 	"juice4halt_disabled",
    # 	"#/home/pi/juice4halt",
    # 	"/etc/rc.local",
    # 	"  - Script de Juice4Halt: %s" % red("DESHABILITADO"),
    # 	"  - Script de Juice4Halt: %s" % green("HABILITADO")))

    # print(stringFoundInFile(
    # 	"rm_log_txt",
    # 	"rm /log.txt",
    # 	"/etc/rc.local",
    # 	"  - Borrado de /log.txt: %s" % green("OK"),
    # 	"  - %s" % red("Falta comando para borrado de /log.txt")))

    print(stringFoundInFile(
        "rm_nmea_txt",
        "rm /NMEA.txt",
        "/etc/rc.local",
        "  - Borrado de /NMEA.txt: %s" % green("OK"),
        "  - %s" % red("Falta comando para borrado de /NMEA.txt")))

    print(stringFoundInFile(
        "rm_var_log_daemon",
        "rm /var/log/daemon*",
        "/etc/rc.local",
        "  - Borrado de /var/log/daemon*: %s" % green("OK"),
        "  - %s" % red("Falta comando para borrado de /var/log/daemon*")))

    print(stringFoundInFile(
        "rm_var_log_syslog",
        "rm /var/log/syslog*",
        "/etc/rc.local",
        "  - Borrado de /var/log/syslog*: %s" % green("OK"),
        "  - %s" % red("Falta comando para borrado de /var/log/syslog*")))

    # ------
    print("")
    print(blue("- Revisando hardware USB"))
    found_arduino = check("Arduino Nano", usb_nano)
    gps_model = check_gps_config()
    if gps_model=="GPS_USB":
        check("GPS", usb_gps)
    else:
        if found_arduino: print(green("    GPS_MASTER configurado en Arduino Nano, OK"))
        else: print(red("  - GPS_MASTER configurado, pero no encuentro Arduino Nano"))


    # ------
    print("")
    print(blue("- Revisando servicios"))
    print("  [ mining-server ]              %s" % serviceStatus2("mining-server"))
    print("  [ mining-serial ]              %s" % serviceStatus2("mining-serial"))
    print("  [ mining-autoupload-gps ]      %s" % serviceStatus2("mining-autoupload-gps"))
    print("  [ mining-autoupload ]          %s" % serviceStatus2("mining-autoupload"))
    print("  [ mining-config ]              %s" % serviceStatus2("mining-config"))
    print("  [ mining-monitor ]             %s" % serviceStatus2("mining-monitor"))
    print("  [ juice4halt ]                 %s" % serviceStatus2("juice4halt"))
    print("  [ mining-log ]                 %s" % serviceStatus2("mining-log"))
    print("  [ mining-id ]                  %s" % serviceStatus2("mining-id"))
    if gps_model=="GPS_USB":
        print("  [ mining-gps ]             %s" % serviceStatus("mining-gps"))

    print("")
    print("-----------------------------------------------------")
    print("Fin de reporte para [ %s ], id %d" % (getProductName(), getProductId()))
    print("")


    url = "https://mother.eye3.cl/get_last_check/%d" % getProductId()
    print("Checking last report in %s ..." % url)
    r = requests.get(url, verify="/etc/ssl/certs/ca-certificates.crt")	

    if (r.content.decode() == "false"):
        print("Actualizando Reporte ...")
        FINAL_REPORT['last_check_date'] = "1970-01-01 00:00:00"
        r = requests.post("https://mother.eye3.cl/push_new_check", data={'json': json.dumps(FINAL_REPORT)}, verify="/etc/ssl/certs/ca-certificates.crt")
    else:
        data = json.loads(r.content)
        last_count = data['problems_found']
        problem_count = FINAL_REPORT['problems_found']
        print("last_count: %s" % last_count)
        print("problem_count: %s" % problem_count)
        if (int(last_count) != int(problem_count)):
            print("Hay cambios respecto del ultimo reporte, actualizando ...")
            r = requests.post("https://mother.eye3.cl/push_new_check", verify="/etc/ssl/certs/ca-certificates.crt", data={'json': json.dumps(FINAL_REPORT)})
        else:
            print("Nada ha cambiado desde el ultimo reporte, todo OK")
    print("Check Listo :)")
    print("")
    
