import subprocess
import datetime
import actualizacion_datalogger


class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        self.nombre=res.decode().split('-')
        return self.nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        try:
            self.log("Actualizando a Mining 2.1.23...")

            print('[1] Actualizando pip3')
            self.comando('python3 -m pip install --upgrade pip')
            print('[2] Pip3 Actualizado')

            ##########Cambiar nombre servicio version
            print('[3] Actualizando servicios de actualizacion')
            self.comando('sudo cp /etc/systemd/system/version.service /etc/systemd/system/mining-actualizar.service',0)
            self.comando('sudo systemctl daemon-reload',0)
            self.comando('sudo systemctl enable mining-actualizar.service',0)
            self.comando('sudo systemctl stop autoUpdate',0)
            self.comando('sudo systemctl disable autoUpdate',0)
            self.comando('sudo mv /etc/systemd/system/autoUpdate.service /etc/systemd/system/mining-update.service',0)
            self.comando('sudo systemctl daemon-reload',0)
            self.comando('sudo systemctl enable mining-update.service',0)
            self.comando('sudo systemctl restart mining-update',0)
            self.comando('sudo rm /bin/version',0)
            print('[4] Servicios de actualizacion actualizados')

            ##########Cambiar clave de acceso pi
            print('[5] Cambiando clave ususario pi')
            self.comando('sudo sh cambioclave_pi.sh')
            print('[6] Calve usuario pi reemplazada')

            ########CAmbiar URL de actualizar
            print('[7] Actualizando ruta de actualizacion')
            try:
                self.comando('sudo cp actualizar /bin/actualizar')
            except:
                print('Error actualizando URL')
            print('[8] Ruta de actualizacion actualizada')

                
            #####Agregar config y comandos id y name
            print('[9] Actualizando config')
            self.comando('sudo cp config.json /etc/mining/config.json')
            self.reemplazar('/etc/mining/config.json','base-000',self.getProductName())
            self.reemplazar('/etc/mining/config.json','123456',str(self.getProductId()))
            self.comando('sudo cp machineid /bin/machineid')
            self.comando('sudo cp machinename /bin/machinename')
            self.comando('sudo chmod 777 /bin/machineid')
            self.comando('sudo chmod 777 /bin/machinename')
            print('[10] Config Actualizado')

            print('[11] Actualizando mining-health')
            self.comando('sudo cp mining-health /bin/mining-health')
            out1 = subprocess.check_output(['ls', '/etc/systemd/system/'])
            if 'mining-cam' not in out1.decode():
                self.comando('sudo cp mining-cam.service /etc/systemd/system/mining-cam.service')
            if 'mining-web' not in out1.decode():
                self.comando('sudo cp mining-web.service /etc/systemd/system/mining-web.service')
            self.comando('sudo systemctl restart mining-health.service')
            print('[12] Mining-health actualizado')

            ###########Cambiar live y agregar que se vean los datalogger
            if self.nombre!='tablet':
                print('[13] Actualizando live')
                self.comando('sudo sh /srv/live/uninstall.sh')
                self.comando('sudo cp -r live /srv/')
                self.comando('sudo sh /srv/live/install.sh')   
                self.comando('sudo mkdir /srv/checks/ecom_mining',0)
                self.comando('sudo cp check_ecom.py /srv/checks/ecom_mining/check_equipo.py')
                self.comando('sudo mkdir /srv/checks/mmr_mining',0)
                self.comando('sudo cp check_mmr.py /srv/checks/mmr_mining/check_equipo.py')
                self.comando('sudo cp datalogger /bin/datalogger')
                self.comando('sudo chmod 777 /bin/datalogger')
                print('[14] Live actualizado')

                print('[15] Actualizando comando wifi')
                self.comando('sudo cp wifi /bin/wifi')
                self.comando('sudo chmod 777 /bin/wifi')
                print('[16] Comando wifi actualizado')

                print('[17] Actualizando comando mining...')
                self.comando('sudo cp mining /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[18] Comando mining Actualizado')

                ## ACTUALIZAR CENTINELA A DATALOGGER MINING ##
                print("[19] Instalando Datalogger")
                if self.nombre == "ecom": actualizacion_datalogger.actualizar_ecom()
                elif self.nombre == "mmr": actualizacion_datalogger.actualizar_mmr()
                elif self.nombre == "gimp": actualizacion_datalogger.actualizar_gimp()
                print("[20] Datalogger actualizado")

                ## CREAR SERVICIO CHECK DATALOGGER MINING ##
                print("[21] Instalando servicio de instalación de datalogger")
                self.comando('sudo cp -r check_datalogger /etc/mining')
                self.comando('sudo sh /etc/mining/check_datalogger/install.sh')
                print("Servicio check datalogger instalado")
                print("[22] Servicio check datalogger instalado")

            else:
                print('[13] Actualizando live')
                self.comando('sudo sh /home/pi/live/uninstall.sh')
                self.comando('sudo cp -r live /home/pi/')
                self.reemplazar('/home/pi/live/install.sh','srv','home/pi')
                self.reemplazar('/home/pi/live/mining-topic/install.sh','srv','home/pi')
                self.reemplazar('/home/pi/live/mining-live.service','srv','home/pi')
                self.reemplazar('/home/pi/live/mining-topic/mining-topic.service','srv','home/pi')
                self.comando('sudo sh /home/pi/live/install.sh')
                print('[14] Live actualizado')

                ###########Agregar root a tablet
                print('[15] Instalando usuario root en tablet')
                self.reemplazar('/etc/ssh/sshd_config','#PermitRootLogin prohibit-password','PermitRootLogin yes')
                self.comando('sudo systemctl restart sshd')
                self.comando('sudo sh cambioclave_root.sh')
                print('[16] Usuario root instalado')
                
                print('[17] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[18] Comando mining Actualizado')
        

            file = open("/etc/mining/version", "w")
            file.write("21\n")
            file.close()

            self.log("Actualizacion a Mining 2.1.23 Finalizada")

        except:
            self.log("Error actualizando el sistema")

#####RUN########
entorno = Actualizar()
entorno.app()
