import requests
import time
import json
import sys
import traceback
import sys
from datetime import datetime


sys.path.append('/srv/datalogger_ecom/')
from lib.utils import Utils
from lib import mqtt
from database.models import Database

class AutouploadGPS(Utils):
    def __init__(self, log_id = "AutouploadGPS", filepath = "/gps_live.json"):
        self.log_id = log_id
        self.machine_name = self.get_product_name()
        self.machine_id = self.get_product_id()
        self.database = Database()
        self.filepath = filepath
        self.previous_data = None
        self.client = mqtt.connect()
        self.clean_database()
        self.update_topic()


    def clean_database(self):
        try:
            # Delete old data than 2 hours everytime init script
            print("Delete old gps data if there is buffer ")
            condition = time.time() - (60*60*2)
            self.database.delete_rows(column= "timestamp", operator= "<", condition_value= condition)

        except:
            e = sys.exc_info()
            print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])

    def update_topic(self):
        try:
            f = open('/srv/datalogger_ecom/config_ecom.json')
            config:dict = json.load(f)

            # MINING
            self.activated_mining = config["AUTOUPLOAD"]["MINING"]["ACTIVATED"] 
            self.topic = config["AUTOUPLOAD"]["MINING"]["LOCATION"]

            # EYE3
            self.activated_eye3 = config["AUTOUPLOAD"]["EYE3"]["ACTIVATED"] 
            self.url = config["AUTOUPLOAD"]["EYE3"]["LOCATION"]

        except:
            self.activated_mining = 0
            self.topic = ""

            self.activated_eye3 = 0
            self.url = ""

            e = sys.exc_info()
            print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])

    def check_gps_data(self):
        try:
            # 1. Check Buffer
            if self.activated_mining: self.check_buffer()

            # 2. Check current gps data
            print("Check data")
            f = open(self.filepath)
            current_data:dict = json.load(f)
            if current_data and self.previous_data!= current_data:
                self.previous_data = current_data
                if current_data["latitude"] !=-1 and current_data["longitude"]!=-1:

                    # 2.1 Upload data eye3
                    if self.activated_eye3: self.upload_http(current_data, self.url)
                    else: print("Envio de data a EYE3 esta desactivado")

                    # 2.2 Upload data MQTT Mining
                    if self.activated_mining:
                        # First check if still have data in buffer
                        if self.database.get_gps_data():
                            # Add new data to buffer
                            self.add_data_to_buffer(current_data)

                        # If not, upload new data
                        else:
                            if not self.upload_mqtt(current_data, self.topic):
                                self.add_data_to_buffer(current_data)
                    else: print("Envio de data a MINING esta desactivado")
                            

        except:
            e = sys.exc_info()
            print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])
        time.sleep(0.5)

    def add_data_to_buffer(self, data):
        self.database.insert_gps_data(lat=data["latitude"], 
                                      lon=data["longitude"],
                                      speed=data["speed"],
                                      timestamp=data["timestamp"]
                                     )

    def check_buffer(self):
        ids_success = []
        try:
            if mqtt.is_alive(self.client):  
                rows = self.database.get_gps_data()
                # id, lat, lon, speed , timestamp
                if rows:
                    print("Hay buffer")
                    for row in rows:
                        data = {
                            "latitude": row[1],
                            "longitude": row[2],
                            "speed_kmh": row[3],
                            "timestamp": row[4]
                        }
                        if self.upload_mqtt(data, self.topic): ids_success.append(row[0])

                    if ids_success:
                        self.database.update_value(table="gps_data", column_name= "uploaded", ids= ids_success)
                
            else:
                # Try reconnect
                print("No se logró conectar a MQTT, try reconnect in 3 seconds")
                time.sleep(3)
                self.client = mqtt.connect()

        except:
            e = sys.exc_info()
            print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])

    


    def upload_mqtt(self, data, topic):
        success = True
        try:
            if mqtt.is_alive(self.client):  
                jsondata= {
                    "measurement": {
                        "machineid": int(self.machine_id),
                        "latitude" : data["latitude"],
                        "longitude": data["longitude"],
                        "speed_kmh": data["speed"],
                    },
                    "equipo": {
                        "name": self.machine_name
                    },
                    "time": data["timestamp"]
                    }
                print(jsondata)
                print(f"Try upload GPS to MQTT {topic}")
                success = mqtt.publish(client= self.client, topic= topic, dict_data= jsondata)
            else:
                # Try reconnect
                print("No se logró conectar a MQTT, try reconnect in 3 seconds")
                time.sleep(3)
                self.client = mqtt.connect()
                
            
        except:
            e = sys.exc_info()
            print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])
        return success

    def upload_http(self, data, url):
        if url:
            print(f"Try upload eye3 data to {url}")
            jsondata = {
                "lastupdate": data["datetime"],
                "name": 'ecom-generic',
                'lat': round(data["latitude"],6),
                'lon': round(data["longitude"],6),
                "type": "CEX",
                "id": self.machine_id
            }

            print(jsondata)
            try:
                # jsondata is text already
                r = requests.post(url, data = {'json': json.dumps(jsondata)}, timeout=2)
                print(r.content)
            except Exception as exc:
                exc_class = str(exc.__class__.__name__).strip()
                exc_description = str(exc)
                print("%s - upload failed: %s, will sleep 60s and restart service" % (exc_class, exc_description))


# Main loop
if __name__ == "__main__":
    print("AUTOUPLOAD GPS")
    upload = AutouploadGPS()
    while True:
        try:
            upload.check_gps_data()
        except:
            e = sys.exc_info()
            print("dumping traceback for [%s: %s]" % (str(e[0].__name__), str(e[1])))
            traceback.print_tb(e[2])
            foo = "bar" # do nothing
        time.sleep(0.25)
