import subprocess
import datetime

class Actualizar():
    def __init__(self):
        self.log_id="ACTUALIZADOR"

    def getProductId(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","robot"]).decode()
        tcp = int(data.split(":")[2])
        return (tcp - 10000) # Mother/Jarvis product ID

    def getProductName(self):
        data = subprocess.check_output(["grep","-nrw","/etc/eye3/config.php","-e","name"]).decode()
        data = data.split("'")[3].strip()
        return data
    
    # Metodo Lanza linea de comando: None
    def comando(self,orden,modo=1):
        orden_s=orden.split(' ')
        if modo==1:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        elif modo==0:
            try:
                res=subprocess.check_output(orden_s)
                if res.decode()!='\n' or res.decode()!='':
                    print(res.decode())
            except: pass

    # Metodo entrega tipo de equipo: STRING
    def tipo(self):
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula


    # Metodo entrega el numero del equipo: INT
    # Ejemplo: ecom-500 entrega 500
    def numero(self):
        res=subprocess.check_output('machinename')
        num_equipo=res.decode().split('-')
        try:
            return int(num_equipo[1])
        except:
            return 0
    
    # Metodo entrega ID; INT
    def id(self):
        res=subprocess.check_output('machineid').decode()
        return int(res)

    # Metodo que agrega el output al log: None
    def log(self,message):
        dt = datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        print("[%s] %s | %s" % (self.log_id, dt, message))
        with open ("/log.txt", "a") as myfile:
            myfile.write("[%s] %s | %s\n" % (self.log_id, dt, message))

    # Meotod reemplaza string en archivo: None
    def reemplazar(self, ruta_archivo, texto_out, texto_in):
        with open(ruta_archivo,'r') as archivo:
            contenido=archivo.read()
        contenido_2 = contenido.replace(texto_out,texto_in)

        with open(ruta_archivo, 'w') as archivo_nuevo:
            archivo_nuevo.write(contenido_2)
    
    def ver_datalogger(self, opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if self.tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if self.tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if self.tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
    
    # Metodo funcional: None
    def app(self):
        self.nombre = self.tipo()
        try:
            self.log("Actualizando a Mining 2.1.24...")
            ###########Cambiar live y agregar que se vean los datalogger

            print('[1] Actualizando mining-id')
            self.comando('sudo cp mining-id /bin/mining-id')
            self.comando('sudo chmod 777 /bin/mining-id')
            self.comando('sudo systemctl restart mining-id')
            print('[2] Mining-id actualizado')

            if self.nombre!='tablet':
                datalogger = self.ver_datalogger()
                print('[3] Actualizando check datalogger')
                self.comando('sudo cp check_datalogger_main.py /etc/mining/check_datalogger/__main__.py')
                self.comando('sudo cp mining-check-datalogger.service /etc/mining/check_datalogger/mining-check-datalogger.service')
                self.comando('sudo cp mining-check-datalogger.service /etc/systemd/system/mining-check-datalogger.service')
                self.comando('sudo systemctl daemon-reload')
                self.comando('sudo systemctl restart mining-check-datalogger.service')
                print('[4] check datalogger actualizado')
                
                if self.nombre == "ecom" and "ECOM MINING" in datalogger:
                        print('[5] Actualizando scripts datalogger mining')
                        self.comando('sudo cp gps_lib.py /srv/datalogger_ecom/gps/gps_lib.py')
                        self.comando('sudo cp autoupload_gps.py /srv/datalogger_ecom/autoupload-gps/__main__.py')
                        self.comando('sudo cp models.py /srv/datalogger_ecom/database/models.py')
                        self.comando('sudo systemctl restart mining-gps.service', 0)
                        self.comando('sudo systemctl restart mining-server.service')
                        self.comando('sudo systemctl restart mining-autoupload-gps.service')
                        self.comando('sudo systemctl restart mining-autoupload.service')

                        print('[6] check datalogger actualizado')

                print('[7] Actualizando comando mining...')
                self.comando('sudo cp mining /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[8] Comando mining Actualizado')

            else:
                print('[3] Actualizando comando mining...')
                self.comando('sudo cp mining_tablet /bin/mining')
                self.comando('sudo chmod 777 /bin/mining')
                print('[4] Comando mining Actualizado')
                    

            file = open("/etc/mining/version", "w")
            file.write("22\n")
            file.close()

            self.log("Actualizacion a Mining 2.1.24 Finalizada")

        except:
            self.log("Error actualizando el sistema")

#####RUN########
entorno = Actualizar()
entorno.app()
