import json
import subprocess
#FAENAS = ["Antucoya", "Candelaria", "Centinela", "Ministro Hales", "Pelambre", "Rodomiro Tomic"]
FAENAS = ["Centinela", "Ministro Hales", "Antucoya", "Candelaria"]

# Metodo Lanza linea de comando: None
def comando(orden,modo=1):
    orden_s=orden.split(' ')
    if modo==1:
        res=subprocess.check_output(orden_s)
        if res.decode()!='\n' or res.decode()!='':
            print(res.decode())
    elif modo==0:
        try:
            res=subprocess.check_output(orden_s)
            if res.decode()!='\n' or res.decode()!='':
                print(res.decode())
        except: pass

def reemplazar(ruta_archivo, texto_out, texto_in):
    with open(ruta_archivo,'r') as archivo:
        contenido=archivo.read()
    contenido_2 = contenido.replace(texto_out,texto_in)

    with open(ruta_archivo, 'w') as archivo_nuevo:
        archivo_nuevo.write(contenido_2)

def get_faena_assigned():
    faena = ""
    try:
        f = open('/srv/live/topic.json')
        config:dict = json.load(f)
        faena = config["topic"].split("/")[0]
    except Exception as ex:
        print(ex)
        print("Error obteniendo Faena")
    return faena

def tipo():
        res=subprocess.check_output('machinename')
        nombre=res.decode().split('-')
        return nombre[0].lower() # return en minuscula

def ver_datalogger(opcion= 2):
        lista=[]
        resp=subprocess.check_output(['ls','/srv/']).decode()
        if tipo()=='mmr' and 'pruebas-riego' in resp:
            lista.append('MMR EYE3')
        if 'datalogger_mmr' in resp:
            lista.append('MMR MINING')
        if tipo()=='ecom' and 'dio' in resp:
            res2 = subprocess.check_output(['ls','/srv/dio/']).decode()
            if 'gps_config.json' in res2:
                lista.append('ECOM EYE3 MASTER')
            else:
                lista.append('ECOM EYE3')
        if 'datalogger_ecom' in resp:
            lista.append('ECOM MINING')
        if tipo()=='gimp' and 'dio' in resp:
            lista.append('GIMP EYE3')
        if 'datalogger_gimp' in resp:
            lista.append('GIMP MINING')
        for i in resp.split('\n'):
            if i=='datalogger':
                lista.append('CABINA')
        if len(lista)==0: print('No hay dataloggers instalados')
        #if opcion==1:
        for i in range(len(lista)):
            print(str(i+1)+'. '+lista[i])
        print('')
        if opcion==1:
            return []
        elif opcion==2:
            return lista
        
def actualizar_ecom():
    try:
        dataloggers = ver_datalogger()
        faena = get_faena_assigned()
        if faena in FAENAS:
            # 1. Desinstalar datalogger eye3
            if "ECOM EYE3 MASTER" in dataloggers or "ECOM EYE3" in dataloggers:
                reemplazar('/srv/dio/desinstalar_datalogger.sh', 'sh /srv/dio/socketio-server-js/uninstall.sh','cd /srv/dio; sh /srv/dio/socketio-server-js/uninstall.sh')
                comando('sh /srv/dio/desinstalar_datalogger.sh')
                try:
                    comando('rm -r /srv/dio')
                except: pass
                try:
                    comando('rm -r /srv/mysqltools-caex')
                    comando('rm -r /srv/mysqltools-caex.tar.gz')
                except: pass
                print('Datalogger EYE3 completamente desinstalado')
            

            # 2. Instalar datalogger Mining, solo si no lo encuentra
            if not "ECOM MINING" in dataloggers:
                comando("cd /")
                comando("sudo wget -O datalogger_ecom-main.zip http://tunel.mine-360.com/datalogger_ecom-main.zip")
                comando("sudo unzip datalogger_ecom-main.zip")
                comando("cp -r datalogger_ecom-main /srv/datalogger_ecom")
                comando("sh /srv/datalogger_ecom/install.sh")
                comando("sudo rm /datalogger_ecom-main.zip", 0)
                print("Datalogger ecom instalado correctamente")

            else:
                print("Datalogger ya esta actualizado")

        else:
            print(f"La faena {faena} no esta configurada para actualizacion de dataloggers")

    except Exception as ex:
        print(ex)
        print("Error actualizando datalogger ecom")



def actualizar_mmr():
    try:
        dataloggers = ver_datalogger()
        faena = get_faena_assigned()
        if faena in FAENAS:
            # 1. Desinstalar datalogger eye3
            if 'MMR EYE3' in dataloggers:
                try:
                    comando('sh /srv/pruebas-riego/instalables/desinstalar_datalogger')
                except: 
                    comando('wget -O /desinstalar_mmr.sh http://tunel.mine-360.com/desisntalar_mmr')
                    comando('sh /desinstalar_mmr.sh')
                    comando('rm /desinstalar_mmr.sh')
                try:
                    comando('rm -r /srv/pruebas-riego')
                except: pass
                comando('rm -r /srv/mysqltools-regador')
                comando('rm -r /srv/mmr2-configure')
                comando('sudo systemctl stop autoupload')
                comando('sudo systemctl disable autoupload')
                comando('sudo systemctl daemon-reload')
                comando('sudo systemctl systemctl reset-failed')
                print('Datalogger completamente desinstalado')


            # 2. Instalar datalogger Mining, solo si no lo encuentra
            if not "MMR MINING" in dataloggers:
                comando("cd /")
                comando("sudo wget -O datalogger_mmr-main.zip http://tunel.mine-360.com/datalogger_mmr-main.zip")
                comando("sudo unzip datalogger_mmr-main.zip")
                comando("cp -r datalogger_mmr-main /srv/datalogger_mmr")
                comando("sh /srv/datalogger_mmr/install.sh")
                comando("sudo rm /datalogger_mmr-main.zip", 0)
                print("Datalogger MMR instalado correctamente")


            else:
                print("Datalogger ya esta actualizado")

        else:
            print(f"La faena {faena} no esta configurada para actualizacion de dataloggers")

    except Exception as ex:
        print(ex)
        print("Error actualizando datalogger ecom")
    


def actualizar_gimp():
    try:
        dataloggers = ver_datalogger()
        faena = get_faena_assigned()
        if faena in FAENAS:
            # 1. Desinstalar datalogger eye3
            if "GIMP EYE3" in dataloggers:
                reemplazar('/srv/dio/desinstalar_datalogger.sh', 'sh /srv/dio/socketio-server-js/uninstall.sh','cd /srv/dio; sh /srv/dio/socketio-server-js/uninstall.sh')
                comando('sh /srv/dio/desinstalar_datalogger.sh')
                try:
                    comando('rm -r /srv/dio')
                except: pass
                try:
                    comando('rm -r /srv/mysqltools-caex')
                    comando('rm -r /srv/mysqltools-caex.tar.gz')
                except: pass
                print('Datalogger EYE3 completamente desinstalado')

            # 2. Instalar datalogger Mining, solo si no lo encuentra
            if not "GIMP MINING" in dataloggers:
                # Instalar datalogger mining
                comando("cd /")
                comando("sudo wget -O datalogger_gimp-main.zip http://tunel.mine-360.com/datalogger_gimp-main.zip")
                comando("sudo unzip datalogger_gimp-main.zip")
                comando("cp -r datalogger_gimp-main /srv/datalogger_gimp")
                comando("sh /srv/datalogger_gimp/install.sh")
                comando("sudo rm /datalogger_gimp-main.zip", 0)
                print("Datalogger GIMP instalado correctamente")
            
            else:
                print("Datalogger ya esta actualizado")

        else:
            print(f"La faena {faena} no esta configurada para actualizacion de dataloggers")

    except Exception as ex:
        print(ex)
        print("Error actualizando datalogger ecom")
    



if __name__ == "__main__":
    datalogger_type = tipo()
    if datalogger_type == "ecom":
        actualizar_ecom()
    elif datalogger_type == "mmr":
        actualizar_mmr()
    elif datalogger_type == "gimp":
        actualizar_gimp()
